/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.wiremock;

import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.StubGenerator;
import org.springframework.util.StreamUtils;

public abstract class DslToWireMockConverter
implements StubGenerator {
    private static final Log log = LogFactory.getLog(DslToWireMockConverter.class);

    @Override
    public String generateOutputFileNameForInput(String inputFileName) {
        return inputFileName.replaceAll(this.extension(inputFileName), "json");
    }

    private String extension(String inputFileName) {
        int i = inputFileName.lastIndexOf(".");
        if (i > 0) {
            return inputFileName.substring(i + 1);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canReadStubMapping(File mapping) {
        if (!mapping.getName().endsWith(".json")) {
            return false;
        }
        try (InputStream stream = Files.newInputStream(mapping.toPath(), new OpenOption[0]);){
            StubMapping.buildFrom((String)StreamUtils.copyToString((InputStream)stream, (Charset)Charset.forName("UTF-8")));
            boolean bl = true;
            return bl;
        }
        catch (JsonException | IOException e) {
            if (!log.isDebugEnabled()) return false;
            log.debug((Object)"Cannot read file", e);
            return false;
        }
    }
}

