/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.refresh;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.bootstrap.ConfigurableBootstrapContext;
import org.springframework.boot.bootstrap.DefaultBootstrapContext;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.util.Instantiator;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.context.config.ContextRefreshedWithApplicationEvent;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ConfigDataContextRefresher
extends ContextRefresher
implements ApplicationListener<ContextRefreshedWithApplicationEvent> {
    private SpringApplication application;

    @Deprecated
    public ConfigDataContextRefresher(ConfigurableApplicationContext context, RefreshScope scope) {
        super(context, scope);
    }

    public ConfigDataContextRefresher(ConfigurableApplicationContext context, RefreshScope scope, RefreshAutoConfiguration.RefreshProperties properties) {
        super(context, scope, properties);
    }

    public void onApplicationEvent(ContextRefreshedWithApplicationEvent event) {
        this.application = event.getSpringApplication();
    }

    @Override
    protected void updateEnvironment() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Re-processing environment to add config data");
        }
        StandardEnvironment environment = this.copyEnvironment(this.getContext().getEnvironment());
        ConfigurableBootstrapContext bootstrapContext = (ConfigurableBootstrapContext)this.getContext().getBeanProvider(ConfigurableBootstrapContext.class).getIfAvailable(DefaultBootstrapContext::new);
        PassthruDeferredLogFactory logFactory = new PassthruDeferredLogFactory();
        List classNames = SpringFactoriesLoader.loadFactoryNames(EnvironmentPostProcessor.class, (ClassLoader)this.getClass().getClassLoader());
        Instantiator instantiator = new Instantiator(EnvironmentPostProcessor.class, parameters -> {
            parameters.add(DeferredLogFactory.class, (Object)logFactory);
            parameters.add(Log.class, arg_0 -> ((DeferredLogFactory)logFactory).getLog(arg_0));
            parameters.add(ConfigurableBootstrapContext.class, (Object)bootstrapContext);
            parameters.add(BootstrapContext.class, (Object)bootstrapContext);
            parameters.add(BootstrapRegistry.class, (Object)bootstrapContext);
        });
        List postProcessors = instantiator.instantiate((Collection)classNames);
        for (EnvironmentPostProcessor postProcessor : postProcessors) {
            postProcessor.postProcessEnvironment((ConfigurableEnvironment)environment, this.application);
        }
        MutablePropertySources target = this.getContext().getEnvironment().getPropertySources();
        String targetName = null;
        for (PropertySource source : environment.getPropertySources()) {
            String name = source.getName();
            if (target.contains(name)) {
                targetName = name;
            }
            if (this.standardSources.contains(name)) continue;
            if (target.contains(name)) {
                target.replace(name, source);
                continue;
            }
            if (targetName != null) {
                target.addAfter(targetName, source);
            } else {
                target.addFirst(source);
            }
            targetName = name;
        }
    }

    static class PassthruDeferredLogFactory
    implements DeferredLogFactory {
        PassthruDeferredLogFactory() {
        }

        public Log getLog(Supplier<Log> destination) {
            return destination.get();
        }

        public Log getLog(Class<?> destination) {
            return this.getLog(() -> LogFactory.getLog((Class)destination));
        }

        public Log getLog(Log destination) {
            return this.getLog(() -> destination);
        }
    }
}

