/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.cloud.bootstrap.encrypt.AbstractEnvironmentDecrypt;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class EnvironmentDecryptApplicationInitializer
extends AbstractEnvironmentDecrypt
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME = "decryptedBootstrap";
    private int order = -2147483633;
    private final TextEncryptor encryptor;

    public EnvironmentDecryptApplicationInitializer(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ApplicationContext parent;
        PropertySource bootstrap;
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (!PropertyUtils.bootstrapEnabled((Environment)environment) && !PropertyUtils.useLegacyProcessing((Environment)environment)) {
            return;
        }
        MutablePropertySources propertySources = environment.getPropertySources();
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        if (!propertySources.contains(DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME) && (bootstrap = propertySources.get("bootstrap")) != null) {
            MutablePropertySources bootstrapSources = new MutablePropertySources();
            bootstrapSources.addFirst(bootstrap);
            Map<String, Object> map = this.decrypt(this.encryptor, (PropertySources)bootstrapSources);
            if (!map.isEmpty()) {
                found.addAll(map.keySet());
                this.insert((ApplicationContext)applicationContext, (PropertySource<?>)new SystemEnvironmentPropertySource(DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME, map));
            }
        }
        this.removeDecryptedProperties((ApplicationContext)applicationContext);
        Map<String, Object> map = this.decrypt(this.encryptor, (PropertySources)propertySources);
        if (!map.isEmpty()) {
            found.addAll(map.keySet());
            this.insert((ApplicationContext)applicationContext, (PropertySource<?>)new SystemEnvironmentPropertySource("decrypted", map));
        }
        if (!found.isEmpty() && (parent = applicationContext.getParent()) != null) {
            parent.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(parent, found));
        }
    }

    private void insert(ApplicationContext applicationContext, PropertySource<?> propertySource) {
        for (ApplicationContext parent = applicationContext; parent != null; parent = parent.getParent()) {
            Environment environment = parent.getEnvironment();
            if (!(environment instanceof ConfigurableEnvironment)) continue;
            ConfigurableEnvironment mutable = (ConfigurableEnvironment)environment;
            this.insert(mutable.getPropertySources(), propertySource);
        }
    }

    private void insert(MutablePropertySources propertySources, PropertySource<?> propertySource) {
        if (propertySources.contains("bootstrap")) {
            if (DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME.equals(propertySource.getName())) {
                propertySources.addBefore("bootstrap", propertySource);
            } else {
                propertySources.addAfter("bootstrap", propertySource);
            }
        } else {
            propertySources.addFirst(propertySource);
        }
    }

    private void removeDecryptedProperties(ApplicationContext applicationContext) {
        for (ApplicationContext parent = applicationContext; parent != null; parent = parent.getParent()) {
            if (!(parent.getEnvironment() instanceof ConfigurableEnvironment)) continue;
            ((ConfigurableEnvironment)parent.getEnvironment()).getPropertySources().remove("decrypted");
        }
    }
}

