/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.SystemDefaultCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.springframework.cloud.config.server.proxy.ProxyHostCredentialsProvider;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.cloud.config.server.proxy.SchemeBasedRoutePlanner;
import org.springframework.cloud.config.server.support.HttpEnvironmentRepositoryProperties;
import org.springframework.util.CollectionUtils;

public final class HttpClientSupport {
    private HttpClientSupport() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static HttpClientBuilder builder(HttpEnvironmentRepositoryProperties environmentProperties) throws GeneralSecurityException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        if (environmentProperties.isSkipSslValidation()) {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (certificate, authType) -> true);
            SSLConnectionSocketFactory sslConnectionSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContextBuilder.build()).setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
            connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        }
        if (!CollectionUtils.isEmpty(environmentProperties.getProxy())) {
            ProxyHostProperties httpsProxy = environmentProperties.getProxy().get((Object)ProxyHostProperties.ProxyForScheme.HTTPS);
            ProxyHostProperties httpProxy = environmentProperties.getProxy().get((Object)ProxyHostProperties.ProxyForScheme.HTTP);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SchemeBasedRoutePlanner(httpsProxy, httpProxy));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)new ProxyHostCredentialsProvider(httpProxy, httpsProxy));
        } else {
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)new SystemDefaultCredentialsProvider());
        }
        httpClientBuilder.disableRedirectHandling();
        int timeout = environmentProperties.getTimeout() * 1000;
        connectionManagerBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeout, TimeUnit.MILLISECONDS).build());
        return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManagerBuilder.build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout((long)timeout, TimeUnit.MILLISECONDS).build());
    }
}

