/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.io.File;
import java.util.Map;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;

public class FileBasedSshSessionFactory
extends SshdSessionFactory {
    private final Map<String, JGitEnvironmentProperties> sshKeysByHostname;

    public FileBasedSshSessionFactory(Map<String, JGitEnvironmentProperties> sshKeysByHostname) {
        this.sshKeysByHostname = sshKeysByHostname;
        assert (this.sshKeysByHostname.entrySet().size() > 0);
    }

    protected SshConfigStore createSshConfigStore(File homeDir, File configFile, String localUserName) {
        return configFile == null ? null : new OpenSshConfigFile(homeDir, configFile, localUserName){

            public OpenSshConfigFile.HostEntry lookup(@NonNull String hostName, int port, String userName) {
                OpenSshConfigFile.HostEntry hostEntry = super.lookup(hostName, port, userName);
                JGitEnvironmentProperties sshProperties = FileBasedSshSessionFactory.this.sshKeysByHostname.get(hostName);
                if (sshProperties == null) {
                    return hostEntry;
                }
                hostEntry.setValue("StrictHostKeyChecking", sshProperties.isStrictHostKeyChecking() ? "yes" : "no");
                return hostEntry;
            }
        };
    }
}

