/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthentication;
import org.springframework.vault.authentication.CubbyholeAuthenticationOptions;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestOperations;

public class CubbyholeClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public CubbyholeClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.CUBBYHOLE);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        String token = vaultProperties.getToken();
        Assert.hasText((String)token, (String)this.missingPropertyForAuthMethod("token", VaultEnvironmentProperties.AuthenticationMethod.CUBBYHOLE));
        CubbyholeAuthenticationOptions options = CubbyholeAuthenticationOptions.builder().wrapped().initialToken(VaultToken.of((String)token)).build();
        return new CubbyholeAuthentication(options, vaultRestOperations);
    }
}

