/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.config.server.encryption.CipherEnvironmentEncryptor;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.cloud.config.server.encryption.KeyStoreTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={KeyProperties.class})
public class EncryptionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.config.server.encrypt.enabled"}, matchIfMissing=true)
    public EnvironmentEncryptor environmentEncryptor(TextEncryptorLocator textEncryptorLocator) {
        return new CipherEnvironmentEncryptor(textEncryptorLocator);
    }

    @Configuration
    @ConditionalOnClass(value={RsaSecretEncryptor.class})
    @ConditionalOnProperty(value={"encrypt.keyStore.location"}, matchIfMissing=false)
    @EnableConfigurationProperties(value={KeyProperties.class})
    protected static class KeyStoreConfiguration {
        @Autowired
        private KeyProperties key;

        protected KeyStoreConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TextEncryptorLocator textEncryptorLocator() {
            KeyProperties.KeyStore keyStore = this.key.getKeyStore();
            KeyStoreTextEncryptorLocator locator = new KeyStoreTextEncryptorLocator(new KeyStoreKeyFactory(keyStore.getLocation(), keyStore.getPassword().toCharArray()), keyStore.getSecret(), keyStore.getAlias());
            locator.setRsaAlgorithm(this.key.getRsa().getAlgorithm());
            locator.setSalt(this.key.getRsa().getSalt());
            locator.setStrong(this.key.getRsa().isStrong());
            return locator;
        }
    }

    @ConditionalOnMissingBean(value={TextEncryptor.class})
    protected static class DefaultTextEncryptorConfiguration {
        @Autowired
        private KeyProperties key;

        protected DefaultTextEncryptorConfiguration() {
        }

        @Bean
        public TextEncryptor nullTextEncryptor() {
            if (StringUtils.hasText((String)this.key.getKey())) {
                return new EncryptorFactory().create(this.key.getKey());
            }
            return Encryptors.noOpText();
        }
    }
}

