/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.loadbalancer.BlockingLoadBalancerInterceptor;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class DeferringLoadBalancerInterceptor
implements ClientHttpRequestInterceptor {
    private final ObjectProvider<BlockingLoadBalancerInterceptor> loadBalancerInterceptorProvider;
    private @Nullable BlockingLoadBalancerInterceptor delegate;

    public DeferringLoadBalancerInterceptor(ObjectProvider<BlockingLoadBalancerInterceptor> loadBalancerInterceptorProvider) {
        this.loadBalancerInterceptorProvider = loadBalancerInterceptorProvider;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.tryResolveDelegate();
        return this.delegate.intercept(request, body, execution);
    }

    private void tryResolveDelegate() {
        if (this.delegate == null) {
            this.delegate = (BlockingLoadBalancerInterceptor)this.loadBalancerInterceptorProvider.getIfAvailable();
            if (this.delegate == null) {
                throw new IllegalStateException("LoadBalancer interceptor not available.");
            }
        }
    }

    ObjectProvider<BlockingLoadBalancerInterceptor> getLoadBalancerInterceptorProvider() {
        return this.loadBalancerInterceptorProvider;
    }
}

