/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class InstanceProperties {
    private @Nullable String instanceId;
    private @Nullable String serviceId;
    private @Nullable String host;
    private int port;
    private boolean secure;
    private Map<String, String> metadata = new LinkedHashMap<String, String>();
    private @Nullable URI uri;

    public @Nullable String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(@Nullable String instanceId) {
        this.instanceId = instanceId;
    }

    public @Nullable String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(@Nullable String serviceId) {
        this.serviceId = serviceId;
    }

    public @Nullable String getHost() {
        return this.host;
    }

    public void setHost(@Nullable String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public @Nullable URI getUri() {
        return this.uri;
    }

    public void setUri(@Nullable URI uri) {
        this.uri = uri;
        this.host = this.uri.getHost();
        this.port = this.uri.getPort();
        String scheme = this.uri.getScheme();
        if ("https".equals(scheme)) {
            this.secure = true;
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceProperties instanceProperties = (InstanceProperties)o;
        return this.port == instanceProperties.port && this.secure == instanceProperties.secure && Objects.equals(this.instanceId, instanceProperties.instanceId) && Objects.equals(this.serviceId, instanceProperties.serviceId) && Objects.equals(this.host, instanceProperties.host) && Objects.equals(this.metadata, instanceProperties.metadata) && Objects.equals(this.uri, instanceProperties.uri);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.serviceId, this.host, this.port, this.secure, this.metadata, this.uri);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("instanceId", (Object)this.instanceId).append("serviceId", (Object)this.serviceId).append("host", (Object)this.host).append("port", this.port).append("secure", this.secure).append("metadata", this.metadata).append("uri", (Object)this.uri).toString();
    }

    public ServiceInstance toServiceInstance() {
        Assert.notNull((Object)this.serviceId, (String)"serviceId is required");
        Assert.notNull((Object)this.host, (String)"host is required");
        return new DefaultServiceInstance(this.instanceId, this.serviceId, this.host, this.port, this.secure, this.metadata);
    }
}

