/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.cloud.client.circuitbreaker.ConfigBuilder;

public abstract class AbstractCircuitBreakerFactory<CONF, CONFB extends ConfigBuilder<CONF>> {
    private final ConcurrentHashMap<String, CONF> configurations = new ConcurrentHashMap();

    public void configure(Consumer<CONFB> consumer, String ... ids) {
        for (String id : ids) {
            CONFB builder = this.configBuilder(id);
            consumer.accept(builder);
            Object conf = builder.build();
            this.getConfigurations().put(id, conf);
        }
    }

    protected ConcurrentHashMap<String, CONF> getConfigurations() {
        return this.configurations;
    }

    protected abstract CONFB configBuilder(String var1);

    public abstract void configureDefault(Function<String, CONF> var1);
}

