/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.configuration.CompatibilityVerifier;
import org.springframework.cloud.configuration.CompatibilityVerifierProperties;
import org.springframework.cloud.configuration.CompositeCompatibilityVerifier;
import org.springframework.cloud.configuration.SpringBootVersionVerifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.compatibility-verifier.enabled"}, matchIfMissing=true)
@AutoConfigureOrder(value=0)
@EnableConfigurationProperties(value={CompatibilityVerifierProperties.class})
public class CompatibilityVerifierAutoConfiguration {
    @Bean
    CompositeCompatibilityVerifier compositeCompatibilityVerifier(List<CompatibilityVerifier> verifiers) {
        CompositeCompatibilityVerifier verifier = new CompositeCompatibilityVerifier(verifiers);
        verifier.verifyDependencies();
        return verifier;
    }

    @Bean
    SpringBootVersionVerifier springBootVersionVerifier(CompatibilityVerifierProperties properties) {
        return new SpringBootVersionVerifier(properties.getCompatibleBootVersions());
    }
}

