/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;

public class ResponseData {
    private final HttpStatus httpStatus;
    private final HttpHeaders headers;
    private final MultiValueMap<String, ResponseCookie> cookies;
    private final RequestData requestData;
    private final Integer rawHttpStatus;

    @Deprecated
    public ResponseData(HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, RequestData requestData, Integer rawHttpStatus) {
        this.httpStatus = null;
        this.rawHttpStatus = rawHttpStatus;
        this.headers = headers;
        this.cookies = cookies;
        this.requestData = requestData;
    }

    @Deprecated
    public ResponseData(HttpStatus httpStatus, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, RequestData requestData) {
        this.httpStatus = httpStatus;
        this.rawHttpStatus = httpStatus != null ? Integer.valueOf(httpStatus.value()) : null;
        this.headers = headers;
        this.cookies = cookies;
        this.requestData = requestData;
    }

    @Deprecated
    public ResponseData(ClientResponse response, RequestData requestData) {
        this(response.statusCode(), response.headers().asHttpHeaders(), (MultiValueMap<String, ResponseCookie>)response.cookies(), requestData);
    }

    @Deprecated
    public ResponseData(RequestData requestData, ClientResponse response) {
        this(response.headers().asHttpHeaders(), (MultiValueMap<String, ResponseCookie>)response.cookies(), requestData, response.rawStatusCode());
    }

    @Deprecated
    public ResponseData(ServerHttpResponse response, RequestData requestData) {
        this(response.getStatusCode(), response.getHeaders(), (MultiValueMap<String, ResponseCookie>)response.getCookies(), requestData);
    }

    @Deprecated
    public ResponseData(RequestData requestData, ServerHttpResponse response) {
        this(response.getHeaders(), (MultiValueMap<String, ResponseCookie>)response.getCookies(), requestData, response.getRawStatusCode());
    }

    @Deprecated
    public ResponseData(ClientHttpResponse clientHttpResponse, RequestData requestData) throws IOException {
        this(clientHttpResponse.getStatusCode(), clientHttpResponse.getHeaders(), ResponseData.buildCookiesFromHeaders(clientHttpResponse.getHeaders()), requestData);
    }

    @Deprecated
    public ResponseData(RequestData requestData, ClientHttpResponse clientHttpResponse) throws IOException {
        this(clientHttpResponse.getHeaders(), ResponseData.buildCookiesFromHeaders(clientHttpResponse.getHeaders()), requestData, clientHttpResponse.getRawStatusCode());
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    public RequestData getRequestData() {
        return this.requestData;
    }

    public Integer getRawHttpStatus() {
        return this.rawHttpStatus;
    }

    public String toString() {
        ToStringCreator to = new ToStringCreator((Object)this);
        to.append("httpStatus", (Object)this.httpStatus);
        return to.toString();
    }

    static MultiValueMap<String, ResponseCookie> buildCookiesFromHeaders(HttpHeaders headers) {
        LinkedMultiValueMap newCookies = new LinkedMultiValueMap();
        if (headers == null) {
            return newCookies;
        }
        List cookiesFromHeaders = headers.get((Object)"Cookie");
        if (cookiesFromHeaders != null) {
            cookiesFromHeaders.forEach(cookie -> {
                String[] splitCookie = cookie.split("=");
                if (splitCookie.length < 2) {
                    return;
                }
                newCookies.put((Object)splitCookie[0], Collections.singletonList(ResponseCookie.from((String)splitCookie[0], (String)splitCookie[1]).build()));
            });
        }
        return newCookies;
    }

    public int hashCode() {
        return Objects.hash(this.httpStatus, this.headers, this.cookies, this.requestData, this.rawHttpStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData that = (ResponseData)o;
        return this.httpStatus == that.httpStatus && Objects.equals(this.headers, that.headers) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.requestData, that.requestData) && Objects.equals(this.rawHttpStatus, that.rawHttpStatus);
    }
}

