/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.ConfigurationPropertiesUtils;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreaker;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4jBulkheadProvider;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigurationProperties;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.util.Assert;

public class ReactiveResilience4JCircuitBreakerFactory
extends ReactiveCircuitBreakerFactory<Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration, Resilience4JConfigBuilder> {
    private final ReactiveResilience4jBulkheadProvider bulkheadProvider;
    private Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration;
    private CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
    private TimeLimiterRegistry timeLimiterRegistry = TimeLimiterRegistry.ofDefaults();
    private final Map<String, Customizer<CircuitBreaker>> circuitBreakerCustomizers = new HashMap<String, Customizer<CircuitBreaker>>();
    private final Resilience4JConfigurationProperties resilience4JConfigurationProperties;

    @Deprecated
    public ReactiveResilience4JCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry) {
        this(circuitBreakerRegistry, timeLimiterRegistry, null, null);
    }

    @Deprecated
    public ReactiveResilience4JCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Resilience4JConfigurationProperties resilience4JConfigurationProperties) {
        this(circuitBreakerRegistry, timeLimiterRegistry, null, resilience4JConfigurationProperties);
    }

    public ReactiveResilience4JCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, ReactiveResilience4jBulkheadProvider bulkheadProvider, Resilience4JConfigurationProperties resilience4JConfigurationProperties) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.bulkheadProvider = bulkheadProvider;
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.defaultConfiguration = id -> new Resilience4JConfigBuilder((String)id).circuitBreakerConfig((CircuitBreakerConfig)this.circuitBreakerRegistry.getDefaultConfig()).timeLimiterConfig((TimeLimiterConfig)this.timeLimiterRegistry.getDefaultConfig()).build();
        this.resilience4JConfigurationProperties = resilience4JConfigurationProperties;
    }

    public ReactiveCircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        return this.create(id, id);
    }

    public ReactiveCircuitBreaker create(String id, String groupName) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        Assert.hasText((String)groupName, (String)"A CircuitBreaker must have a group name.");
        Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration defaultConfig = this.getConfigurations().computeIfAbsent(id, this.defaultConfiguration);
        CircuitBreakerConfig circuitBreakerConfig = this.circuitBreakerRegistry.getConfiguration(id).orElseGet(() -> this.circuitBreakerRegistry.getConfiguration(groupName).orElseGet(defaultConfig::getCircuitBreakerConfig));
        TimeLimiterConfig timeLimiterConfig = this.timeLimiterRegistry.getConfiguration(id).orElseGet(() -> this.timeLimiterRegistry.getConfiguration(groupName).orElseGet(defaultConfig::getTimeLimiterConfig));
        Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config = new Resilience4JConfigBuilder(id).circuitBreakerConfig(circuitBreakerConfig).timeLimiterConfig(timeLimiterConfig).build();
        boolean isDisableTimeLimiter = ConfigurationPropertiesUtils.isDisableTimeLimiter(this.resilience4JConfigurationProperties, id, groupName);
        return new ReactiveResilience4JCircuitBreaker(id, groupName, config, this.circuitBreakerRegistry, this.timeLimiterRegistry, Optional.ofNullable(this.circuitBreakerCustomizers.get(id)), this.bulkheadProvider, isDisableTimeLimiter);
    }

    protected Resilience4JConfigBuilder configBuilder(String id) {
        return new Resilience4JConfigBuilder(id);
    }

    public CircuitBreakerRegistry getCircuitBreakerRegistry() {
        return this.circuitBreakerRegistry;
    }

    public TimeLimiterRegistry getTimeLimiterRegistry() {
        return this.timeLimiterRegistry;
    }

    public void configureDefault(Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void configureCircuitBreakerRegistry(CircuitBreakerRegistry registry) {
        this.circuitBreakerRegistry = registry;
    }

    public void addCircuitBreakerCustomizer(Customizer<CircuitBreaker> customizer, String ... ids) {
        for (String id : ids) {
            this.circuitBreakerCustomizers.put(id, customizer);
        }
    }
}

