/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import org.springframework.cloud.client.circuitbreaker.ConfigBuilder;

public class Resilience4JConfigBuilder
implements ConfigBuilder<Resilience4JCircuitBreakerConfiguration> {
    private String id;
    private TimeLimiterConfig timeLimiterConfig = TimeLimiterConfig.ofDefaults();
    private CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.ofDefaults();

    public Resilience4JConfigBuilder(String id) {
        this.id = id;
    }

    public Resilience4JConfigBuilder timeLimiterConfig(TimeLimiterConfig config) {
        this.timeLimiterConfig = config;
        return this;
    }

    public Resilience4JConfigBuilder circuitBreakerConfig(CircuitBreakerConfig circuitBreakerConfig) {
        this.circuitBreakerConfig = circuitBreakerConfig;
        return this;
    }

    public Resilience4JCircuitBreakerConfiguration build() {
        Resilience4JCircuitBreakerConfiguration config = new Resilience4JCircuitBreakerConfiguration();
        config.setId(this.id);
        config.setCircuitBreakerConfig(this.circuitBreakerConfig);
        config.setTimeLimiterConfig(this.timeLimiterConfig);
        return config;
    }

    public static class Resilience4JCircuitBreakerConfiguration {
        private String id;
        private TimeLimiterConfig timeLimiterConfig;
        private CircuitBreakerConfig circuitBreakerConfig;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public TimeLimiterConfig getTimeLimiterConfig() {
            return this.timeLimiterConfig;
        }

        public void setTimeLimiterConfig(TimeLimiterConfig timeLimiterConfig) {
            this.timeLimiterConfig = timeLimiterConfig;
        }

        public CircuitBreakerConfig getCircuitBreakerConfig() {
            return this.circuitBreakerConfig;
        }

        public void setCircuitBreakerConfig(CircuitBreakerConfig circuitBreakerConfig) {
            this.circuitBreakerConfig = circuitBreakerConfig;
        }
    }
}

