/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.datasource.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.aws.jdbc.datasource.support.DatabaseType;
import org.springframework.cloud.aws.jdbc.datasource.support.MapBasedDatabasePlatformSupport;

public class StaticDatabasePlatformSupport
extends MapBasedDatabasePlatformSupport {
    private static final String JDBC_SCHEME_NAME = "jdbc:";
    private final Map<DatabaseType, String> driverClassNameMappings = StaticDatabasePlatformSupport.getDefaultDriverClassNameMappings();
    private final Map<DatabaseType, String> schemeNames = StaticDatabasePlatformSupport.getDefaultSchemeNames();

    private static Map<DatabaseType, String> getDefaultDriverClassNameMappings() {
        HashMap<DatabaseType, String> driverClassNameMappings = new HashMap<DatabaseType, String>();
        driverClassNameMappings.put(DatabaseType.MYSQL, "com.mysql.jdbc.Driver");
        driverClassNameMappings.put(DatabaseType.ORACLE, "oracle.jdbc.OracleDriver");
        driverClassNameMappings.put(DatabaseType.SQLSERVER, "net.sourceforge.jtds.jdbc.Driver");
        driverClassNameMappings.put(DatabaseType.POSTGRES, "org.postgresql.Driver");
        driverClassNameMappings.put(DatabaseType.MARIA, "org.mariadb.jdbc.Driver");
        driverClassNameMappings.put(DatabaseType.AURORA_POSTGRESQL, (String)driverClassNameMappings.get((Object)DatabaseType.POSTGRES));
        driverClassNameMappings.put(DatabaseType.AURORA, (String)driverClassNameMappings.get((Object)DatabaseType.MYSQL));
        return Collections.unmodifiableMap(driverClassNameMappings);
    }

    private static Map<DatabaseType, String> getDefaultSchemeNames() {
        HashMap<DatabaseType, String> schemeNamesMappings = new HashMap<DatabaseType, String>();
        schemeNamesMappings.put(DatabaseType.MYSQL, "jdbc:mysql");
        schemeNamesMappings.put(DatabaseType.ORACLE, "jdbc:oracle:thin");
        schemeNamesMappings.put(DatabaseType.SQLSERVER, "jdbc:jtds:sqlserver");
        schemeNamesMappings.put(DatabaseType.POSTGRES, "jdbc:postgresql");
        schemeNamesMappings.put(DatabaseType.MARIA, "jdbc:mariadb");
        schemeNamesMappings.put(DatabaseType.AURORA_POSTGRESQL, (String)schemeNamesMappings.get((Object)DatabaseType.POSTGRES));
        schemeNamesMappings.put(DatabaseType.AURORA, (String)schemeNamesMappings.get((Object)DatabaseType.MYSQL));
        return Collections.unmodifiableMap(schemeNamesMappings);
    }

    @Override
    protected Map<DatabaseType, String> getDriverClassNameMappings() {
        return this.driverClassNameMappings;
    }

    @Override
    protected Map<DatabaseType, String> getSchemeNames() {
        return this.schemeNames;
    }

    @Override
    protected Map<DatabaseType, String> getAuthenticationInfo() {
        return Collections.singletonMap(DatabaseType.ORACLE, "@");
    }
}

