/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.io.Console;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingSystemProperty;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LoggingSystemProperties {
    private static final BiConsumer<String, String> systemPropertySetter = (name, value) -> {
        if (System.getProperty(name) == null && value != null) {
            System.setProperty(name, value);
        }
    };
    private final Environment environment;
    private final Function<String, String> defaultValueResolver;
    private final BiConsumer<String, String> setter;

    public LoggingSystemProperties(Environment environment) {
        this(environment, null);
    }

    public LoggingSystemProperties(Environment environment, BiConsumer<String, String> setter) {
        this(environment, null, setter);
    }

    public LoggingSystemProperties(Environment environment, Function<String, String> defaultValueResolver, BiConsumer<String, String> setter) {
        Assert.notNull((Object)environment, (String)"'environment' must not be null");
        this.environment = environment;
        this.defaultValueResolver = defaultValueResolver != null ? defaultValueResolver : name -> null;
        this.setter = setter != null ? setter : systemPropertySetter;
    }

    protected Console getConsole() {
        return System.console();
    }

    public final void apply() {
        this.apply(null);
    }

    public final void apply(LogFile logFile) {
        PropertyResolver resolver = this.getPropertyResolver();
        this.apply(logFile, resolver);
    }

    private PropertyResolver getPropertyResolver() {
        Environment environment = this.environment;
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
            PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver((PropertySources)configurableEnvironment.getPropertySources());
            resolver.setConversionService(configurableEnvironment.getConversionService());
            resolver.setIgnoreUnresolvableNestedPlaceholders(true);
            return resolver;
        }
        return this.environment;
    }

    protected void apply(LogFile logFile, PropertyResolver resolver) {
        Charset defaultCharset = this.getDefaultCharset();
        Charset consoleCharset = defaultCharset != null ? defaultCharset : this.getDefaultConsoleCharset();
        Charset fileCharset = defaultCharset != null ? defaultCharset : this.getDefaultFileCharset();
        this.setSystemProperty(LoggingSystemProperty.APPLICATION_NAME, resolver);
        this.setSystemProperty(LoggingSystemProperty.APPLICATION_GROUP, resolver);
        this.setSystemProperty(LoggingSystemProperty.PID, new ApplicationPid().toString());
        this.setSystemProperty(LoggingSystemProperty.CONSOLE_CHARSET, resolver, consoleCharset.name());
        this.setSystemProperty(LoggingSystemProperty.FILE_CHARSET, resolver, fileCharset.name());
        this.setSystemProperty(LoggingSystemProperty.CONSOLE_THRESHOLD, resolver, this::thresholdMapper);
        this.setSystemProperty(LoggingSystemProperty.FILE_THRESHOLD, resolver, this::thresholdMapper);
        this.setSystemProperty(LoggingSystemProperty.EXCEPTION_CONVERSION_WORD, resolver);
        this.setSystemProperty(LoggingSystemProperty.CONSOLE_PATTERN, resolver);
        this.setSystemProperty(LoggingSystemProperty.FILE_PATTERN, resolver);
        this.setSystemProperty(LoggingSystemProperty.CONSOLE_STRUCTURED_FORMAT, resolver);
        this.setSystemProperty(LoggingSystemProperty.FILE_STRUCTURED_FORMAT, resolver);
        this.setSystemProperty(LoggingSystemProperty.LEVEL_PATTERN, resolver);
        this.setSystemProperty(LoggingSystemProperty.DATEFORMAT_PATTERN, resolver);
        this.setSystemProperty(LoggingSystemProperty.CORRELATION_PATTERN, resolver);
        if (logFile != null) {
            logFile.applyToSystemProperties();
        }
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    protected Charset getDefaultCharset() {
        return null;
    }

    protected Charset getDefaultConsoleCharset() {
        Console console = this.getConsole();
        return console != null ? console.charset() : Charset.defaultCharset();
    }

    protected Charset getDefaultFileCharset() {
        return StandardCharsets.UTF_8;
    }

    private void setSystemProperty(LoggingSystemProperty property, PropertyResolver resolver) {
        this.setSystemProperty(property, resolver, Function.identity());
    }

    private void setSystemProperty(LoggingSystemProperty property, PropertyResolver resolver, Function<String, String> mapper) {
        this.setSystemProperty(property, resolver, null, mapper);
    }

    private void setSystemProperty(LoggingSystemProperty property, PropertyResolver resolver, String defaultValue) {
        this.setSystemProperty(property, resolver, defaultValue, Function.identity());
    }

    private void setSystemProperty(LoggingSystemProperty property, PropertyResolver resolver, String defaultValue, Function<String, String> mapper) {
        if (property.getIncludePropertyName() != null && !((Boolean)resolver.getProperty(property.getIncludePropertyName(), Boolean.class, (Object)Boolean.TRUE)).booleanValue()) {
            return;
        }
        String value = property.getApplicationPropertyName() != null ? resolver.getProperty(property.getApplicationPropertyName()) : null;
        value = value != null ? value : this.defaultValueResolver.apply(property.getApplicationPropertyName());
        value = value != null ? value : defaultValue;
        value = mapper.apply(value);
        this.setSystemProperty(property.getEnvironmentVariableName(), value);
        if (property == LoggingSystemProperty.APPLICATION_NAME && StringUtils.hasText((String)value)) {
            this.setSystemProperty("LOGGED_APPLICATION_NAME", "[%s] ".formatted(value));
        }
    }

    private void setSystemProperty(LoggingSystemProperty property, String value) {
        this.setSystemProperty(property.getEnvironmentVariableName(), value);
    }

    private String thresholdMapper(String input) {
        if ("false".equals(input)) {
            return "OFF";
        }
        return input;
    }

    protected final void setSystemProperty(String name, String value) {
        this.setter.accept(name, value);
    }
}

