/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.sql.init.dependency;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.sql.init.dependency.DatabaseInitializerDetector;
import org.springframework.boot.sql.init.dependency.DependsOnDatabaseInitializationDetector;
import org.springframework.boot.util.Instantiator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class DatabaseInitializationDependencyConfigurer
implements ImportBeanDefinitionRegistrar {
    private final Environment environment;

    DatabaseInitializationDependencyConfigurer(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(DependsOnDatabaseInitializationPostProcessor.class.getName())) {
            return;
        }
        registry.registerBeanDefinition(DependsOnDatabaseInitializationPostProcessor.class.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DependsOnDatabaseInitializationPostProcessor.class, () -> new DependsOnDatabaseInitializationPostProcessor(this.environment)).getBeanDefinition());
    }

    static class DependsOnDatabaseInitializationPostProcessor
    implements BeanFactoryPostProcessor {
        private final Environment environment;

        DependsOnDatabaseInitializationPostProcessor(Environment environment) {
            this.environment = environment;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            Set<String> detectedDatabaseInitializers = this.detectDatabaseInitializers(beanFactory);
            if (detectedDatabaseInitializers.isEmpty()) {
                return;
            }
            for (String dependentDefinitionName : this.detectDependsOnDatabaseInitialization(beanFactory, this.environment)) {
                BeanDefinition definition = DependsOnDatabaseInitializationPostProcessor.getBeanDefinition(dependentDefinitionName, beanFactory);
                String[] dependencies = definition.getDependsOn();
                for (String dependencyName : detectedDatabaseInitializers) {
                    dependencies = StringUtils.addStringToArray((String[])dependencies, (String)dependencyName);
                }
                definition.setDependsOn(dependencies);
            }
        }

        private Set<String> detectDatabaseInitializers(ConfigurableListableBeanFactory beanFactory) {
            List<DatabaseInitializerDetector> detectors = this.instantiateDetectors(beanFactory, this.environment, DatabaseInitializerDetector.class);
            HashSet<String> detected = new HashSet();
            for (DatabaseInitializerDetector detector : detectors) {
                for (String initializerName : detector.detect(beanFactory)) {
                    detected.add(initializerName);
                    beanFactory.getBeanDefinition(initializerName).setAttribute(DatabaseInitializerDetector.class.getName(), (Object)detector.getClass().getName());
                }
            }
            detected = Collections.unmodifiableSet(detected);
            for (DatabaseInitializerDetector detector : detectors) {
                detector.detectionComplete(beanFactory, detected);
            }
            return detected;
        }

        private Collection<String> detectDependsOnDatabaseInitialization(ConfigurableListableBeanFactory beanFactory, Environment environment) {
            List<DependsOnDatabaseInitializationDetector> detectors = this.instantiateDetectors(beanFactory, environment, DependsOnDatabaseInitializationDetector.class);
            HashSet<String> dependentUponDatabaseInitialization = new HashSet<String>();
            for (DependsOnDatabaseInitializationDetector detector : detectors) {
                dependentUponDatabaseInitialization.addAll(detector.detect(beanFactory));
            }
            return dependentUponDatabaseInitialization;
        }

        private <T> List<T> instantiateDetectors(ConfigurableListableBeanFactory beanFactory, Environment environment, Class<T> detectorType) {
            List detectorNames = SpringFactoriesLoader.loadFactoryNames(detectorType, (ClassLoader)beanFactory.getBeanClassLoader());
            Instantiator instantiator = new Instantiator(detectorType, availableParameters -> availableParameters.add(Environment.class, environment));
            List detectors = instantiator.instantiate(detectorNames);
            return detectors;
        }

        private static BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
            try {
                return beanFactory.getBeanDefinition(beanName);
            }
            catch (NoSuchBeanDefinitionException ex) {
                BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
                if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                    return DependsOnDatabaseInitializationPostProcessor.getBeanDefinition(beanName, (ConfigurableListableBeanFactory)parentBeanFactory);
                }
                throw ex;
            }
        }
    }
}

