/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.Undertow;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.xnio.channels.BoundChannel;

public class UndertowWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(UndertowServletWebServer.class);
    private final Object monitor = new Object();
    private final Undertow.Builder builder;
    private final boolean autoStart;
    private final Closeable closeable;
    private Undertow undertow;
    private volatile boolean started = false;

    public UndertowWebServer(Undertow.Builder builder, boolean autoStart) {
        this(builder, autoStart, null);
    }

    public UndertowWebServer(Undertow.Builder builder, boolean autoStart, Closeable closeable) {
        this.builder = builder;
        this.autoStart = autoStart;
        this.closeable = closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                if (!this.autoStart) {
                    return;
                }
                if (this.undertow == null) {
                    this.undertow = this.builder.build();
                }
                this.undertow.start();
                this.started = true;
                logger.info((Object)("Undertow started on port(s) " + this.getPortsDescription()));
            }
            catch (Exception ex) {
                try {
                    if (this.findBindException(ex) != null) {
                        List<Port> failedPorts = this.getConfiguredPorts();
                        List<Port> actualPorts = this.getActualPorts();
                        failedPorts.removeAll(actualPorts);
                        if (failedPorts.size() == 1) {
                            throw new PortInUseException(failedPorts.iterator().next().getNumber());
                        }
                    }
                    throw new WebServerException("Unable to start embedded Undertow", ex);
                }
                catch (Throwable throwable) {
                    this.stopSilently();
                    throw throwable;
                }
            }
        }
    }

    private void stopSilently() {
        try {
            if (this.undertow != null) {
                this.undertow.stop();
                this.closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BindException findBindException(Exception ex) {
        for (Throwable candidate = ex; candidate != null; candidate = candidate.getCause()) {
            if (!(candidate instanceof BindException)) continue;
            return (BindException)candidate;
        }
        return null;
    }

    private String getPortsDescription() {
        List<Port> ports = this.getActualPorts();
        if (!ports.isEmpty()) {
            return StringUtils.collectionToDelimitedString(ports, (String)" ");
        }
        return "unknown";
    }

    private List<Port> getActualPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        try {
            if (!this.autoStart) {
                ports.add(new Port(-1, "unknown"));
            } else {
                for (BoundChannel channel : this.extractChannels()) {
                    ports.add(this.getPortFromChannel(channel));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ports;
    }

    private List<BoundChannel> extractChannels() {
        Field channelsField = ReflectionUtils.findField(Undertow.class, (String)"channels");
        ReflectionUtils.makeAccessible((Field)channelsField);
        return (List)ReflectionUtils.getField((Field)channelsField, (Object)this.undertow);
    }

    private Port getPortFromChannel(BoundChannel channel) {
        SocketAddress socketAddress = channel.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            Field sslField = ReflectionUtils.findField(channel.getClass(), (String)"ssl");
            String protocol = sslField != null ? "https" : "http";
            return new Port(((InetSocketAddress)socketAddress).getPort(), protocol);
        }
        return null;
    }

    private List<Port> getConfiguredPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Object listener : this.extractListeners()) {
            try {
                ports.add(this.getPortFromListener(listener));
            }
            catch (Exception exception) {}
        }
        return ports;
    }

    private List<Object> extractListeners() {
        Field listenersField = ReflectionUtils.findField(Undertow.class, (String)"listeners");
        ReflectionUtils.makeAccessible((Field)listenersField);
        return (List)ReflectionUtils.getField((Field)listenersField, (Object)this.undertow);
    }

    private Port getPortFromListener(Object listener) {
        Field typeField = ReflectionUtils.findField(listener.getClass(), (String)"type");
        ReflectionUtils.makeAccessible((Field)typeField);
        String protocol = ReflectionUtils.getField((Field)typeField, (Object)listener).toString();
        Field portField = ReflectionUtils.findField(listener.getClass(), (String)"port");
        ReflectionUtils.makeAccessible((Field)portField);
        int port = (Integer)ReflectionUtils.getField((Field)portField, (Object)listener);
        return new Port(port, protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            try {
                this.undertow.stop();
                if (this.closeable != null) {
                    this.closeable.close();
                }
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to stop undertow", ex);
            }
        }
    }

    @Override
    public int getPort() {
        List<Port> ports = this.getActualPorts();
        if (ports.isEmpty()) {
            return 0;
        }
        return ports.get(0).getNumber();
    }

    private static final class Port {
        private final int number;
        private final String protocol;

        private Port(int number, String protocol) {
            this.number = number;
            this.protocol = protocol;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Port other = (Port)obj;
            return this.number == other.number;
        }

        public int hashCode() {
            return this.number;
        }

        public String toString() {
            return this.number + " (" + this.protocol + ")";
        }
    }
}

