/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.springframework.boot.json.JsonParser;

public class JacksonJsonParser
implements JsonParser {
    private static final TypeReference<?> MAP_TYPE = new MapTypeReference();
    private static final TypeReference<?> LIST_TYPE = new ListTypeReference();
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Map<String, Object> parseMap(String json) {
        try {
            return (Map)this.objectMapper.readValue(json, MAP_TYPE);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot parse JSON", ex);
        }
    }

    @Override
    public List<Object> parseList(String json) {
        try {
            return (List)this.objectMapper.readValue(json, LIST_TYPE);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot parse JSON", ex);
        }
    }

    private static class ListTypeReference
    extends TypeReference<List<Object>> {
        private ListTypeReference() {
        }
    }

    private static class MapTypeReference
    extends TypeReference<Map<String, Object>> {
        private MapTypeReference() {
        }
    }
}

