/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.yaml.ArrayDocumentMatcher;

public class SpringProfileDocumentMatcher
implements YamlProcessor.DocumentMatcher {
    private static final String[] DEFAULT_PROFILES = new String[]{"^\\s*$"};
    private String[] activeProfiles = new String[0];

    public SpringProfileDocumentMatcher() {
    }

    public SpringProfileDocumentMatcher(String ... profiles) {
        this.addActiveProfiles(profiles);
    }

    public void addActiveProfiles(String ... profiles) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(this.activeProfiles));
        Collections.addAll(set, profiles);
        this.activeProfiles = set.toArray(new String[set.size()]);
    }

    public YamlProcessor.MatchStatus matches(Properties properties) {
        String[] profiles = this.activeProfiles;
        if (profiles.length == 0) {
            profiles = DEFAULT_PROFILES;
        }
        return new ArrayDocumentMatcher("spring.profiles", profiles).matches(properties);
    }
}

