/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

class LoggedExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static LoggedExceptionHandlerThreadLocal handler = new LoggedExceptionHandlerThreadLocal();
    private final Thread.UncaughtExceptionHandler parent;
    private final List<Throwable> exceptions = new ArrayList<Throwable>();

    LoggedExceptionHandler(Thread.UncaughtExceptionHandler parent) {
        this.parent = parent;
    }

    public void register(Throwable exception) {
        this.exceptions.add(exception);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        try {
            if (!this.isRegistered(ex) && this.parent != null) {
                this.parent.uncaughtException(thread, ex);
            }
        }
        finally {
            this.exceptions.clear();
        }
    }

    private boolean isRegistered(Throwable ex) {
        if (this.exceptions.contains(ex)) {
            return true;
        }
        if (ex instanceof InvocationTargetException) {
            return this.isRegistered(ex.getCause());
        }
        return false;
    }

    static LoggedExceptionHandler forCurrentThread() {
        return (LoggedExceptionHandler)handler.get();
    }

    private static class LoggedExceptionHandlerThreadLocal
    extends ThreadLocal<LoggedExceptionHandler> {
        private LoggedExceptionHandlerThreadLocal() {
        }

        @Override
        protected LoggedExceptionHandler initialValue() {
            LoggedExceptionHandler handler = new LoggedExceptionHandler(Thread.currentThread().getUncaughtExceptionHandler());
            Thread.currentThread().setUncaughtExceptionHandler(handler);
            return handler;
        }
    }
}

