/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure.actuate.web;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.webmvc.error.ErrorAttributes;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@Controller
public class ManagementErrorEndpoint {
    private final ErrorAttributes errorAttributes;
    private final ErrorProperties errorProperties;

    public ManagementErrorEndpoint(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        Assert.notNull((Object)errorAttributes, (String)"'errorAttributes' must not be null");
        Assert.notNull((Object)errorProperties, (String)"'errorProperties' must not be null");
        this.errorAttributes = errorAttributes;
        this.errorProperties = errorProperties;
    }

    @RequestMapping(value={"${server.error.path:${error.path:/error}}"})
    @ResponseBody
    public Map<String, @Nullable Object> invoke(ServletWebRequest request) {
        return this.errorAttributes.getErrorAttributes((WebRequest)request, this.getErrorAttributeOptions(request));
    }

    private ErrorAttributeOptions getErrorAttributeOptions(ServletWebRequest request) {
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        if (this.errorProperties.isIncludeException()) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.EXCEPTION});
        }
        if (this.includeStackTrace(request)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STACK_TRACE});
        }
        if (this.includeMessage(request)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.MESSAGE});
        }
        if (this.includeBindingErrors(request)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.BINDING_ERRORS});
        }
        options = this.includePath(request) ? options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.PATH}) : options.excluding(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.PATH});
        return options;
    }

    private boolean includeStackTrace(ServletWebRequest request) {
        return switch (this.errorProperties.getIncludeStacktrace()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getBooleanParameter(request, "trace");
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    private boolean includeMessage(ServletWebRequest request) {
        return switch (this.errorProperties.getIncludeMessage()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getBooleanParameter(request, "message");
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    private boolean includeBindingErrors(ServletWebRequest request) {
        return switch (this.errorProperties.getIncludeBindingErrors()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getBooleanParameter(request, "errors");
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    private boolean includePath(ServletWebRequest request) {
        return switch (this.errorProperties.getIncludePath()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getBooleanParameter(request, "path");
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected boolean getBooleanParameter(ServletWebRequest request, String parameterName) {
        String parameter = request.getParameter(parameterName);
        if (parameter == null) {
            return false;
        }
        return !"false".equalsIgnoreCase(parameter);
    }
}

