/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure;

import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

final class WelcomePage {
    static final WelcomePage UNRESOLVED = new WelcomePage(null, false);
    private final String viewName;
    private final boolean templated;

    private WelcomePage(String viewName, boolean templated) {
        this.viewName = viewName;
        this.templated = templated;
    }

    String getViewName() {
        return this.viewName;
    }

    boolean isTemplated() {
        return this.templated;
    }

    static WelcomePage resolve(TemplateAvailabilityProviders templateAvailabilityProviders, ApplicationContext applicationContext, Resource indexHtmlResource, String staticPathPattern) {
        if (indexHtmlResource != null && "/**".equals(staticPathPattern)) {
            return new WelcomePage("forward:index.html", false);
        }
        if (templateAvailabilityProviders.getProvider("index", applicationContext) != null) {
            return new WelcomePage("index", true);
        }
        return UNRESOLVED;
    }
}

