/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.test.autoconfigure;

import org.htmlunit.WebClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.web.htmlunit.UriBuilderFactoryWebClient;
import org.springframework.boot.webmvc.test.autoconfigure.MockMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebClientBuilder;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

@AutoConfiguration(after={MockMvcAutoConfiguration.class})
@ConditionalOnClass(value={WebClient.class})
@ConditionalOnBooleanProperty(name={"spring.test.mockmvc.webclient.enabled"}, matchIfMissing=true)
public final class MockMvcWebClientAutoConfiguration {
    private static final UriBuilderFactory MOCK_URI_BUILDER_FACTORY = new DefaultUriBuilderFactory("http://localhost");

    @Bean
    @ConditionalOnMissingBean(value={WebClient.class, MockMvcWebClientBuilder.class})
    @ConditionalOnBean(value={MockMvc.class})
    MockMvcWebClientBuilder mockMvcWebClientBuilder(MockMvc mockMvc) {
        return MockMvcWebClientBuilder.mockMvcSetup((MockMvc)mockMvc).withDelegate((WebClient)new UriBuilderFactoryWebClient(MOCK_URI_BUILDER_FACTORY));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MockMvcWebClientBuilder.class})
    WebClient htmlUnitWebClient(MockMvcWebClientBuilder builder) {
        return builder.build();
    }
}

