/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.servlet.ContextPath;
import org.springframework.boot.web.server.servlet.CookieSameSiteSupplier;
import org.springframework.boot.web.server.servlet.Jsp;
import org.springframework.boot.web.server.servlet.Session;
import org.springframework.boot.web.server.servlet.StaticResourceJars;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.util.Assert;

public class ServletWebServerSettings {
    private ContextPath contextPath = ContextPath.DEFAULT;
    private @Nullable String displayName;
    private Session session = new Session();
    private boolean registerDefaultServlet;
    private MimeMappings mimeMappings = MimeMappings.lazyCopy(MimeMappings.DEFAULT);
    private @Nullable File documentRoot;
    private List<ServletContextInitializer> initializers = new ArrayList<ServletContextInitializer>();
    private Jsp jsp = new Jsp();
    private Map<Locale, Charset> localeCharsetMappings = new HashMap<Locale, Charset>();
    private Map<String, String> initParameters = new HashMap<String, String>();
    private List<CookieSameSiteSupplier> cookieSameSiteSuppliers = new ArrayList<CookieSameSiteSupplier>();
    private final Set<String> webListenerClassNames = new HashSet<String>();
    private final StaticResourceJars staticResourceJars = new StaticResourceJars();

    public ContextPath getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(ContextPath contextPath) {
        this.contextPath = contextPath;
    }

    public @Nullable String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean isRegisterDefaultServlet() {
        return this.registerDefaultServlet;
    }

    public void setRegisterDefaultServlet(boolean registerDefaultServlet) {
        this.registerDefaultServlet = registerDefaultServlet;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    public @Nullable File getDocumentRoot() {
        return this.documentRoot;
    }

    public void setDocumentRoot(@Nullable File documentRoot) {
        this.documentRoot = documentRoot;
    }

    public List<? extends ServletContextInitializer> getInitializers() {
        return this.initializers;
    }

    public void setJsp(Jsp jsp) {
        this.jsp = jsp;
    }

    public Jsp getJsp() {
        return this.jsp;
    }

    public Map<Locale, Charset> getLocaleCharsetMappings() {
        return this.localeCharsetMappings;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public List<? extends CookieSameSiteSupplier> getCookieSameSiteSuppliers() {
        return this.cookieSameSiteSuppliers;
    }

    public void setMimeMappings(MimeMappings mimeMappings) {
        Assert.notNull((Object)mimeMappings, (String)"'mimeMappings' must not be null");
        this.mimeMappings = new MimeMappings(mimeMappings);
    }

    public void addMimeMappings(MimeMappings mimeMappings) {
        mimeMappings.forEach(mapping -> this.mimeMappings.add(mapping.getExtension(), mapping.getMimeType()));
    }

    public void setInitializers(List<? extends ServletContextInitializer> initializers) {
        Assert.notNull(initializers, (String)"'initializers' must not be null");
        this.initializers = new ArrayList<ServletContextInitializer>(initializers);
    }

    public void addInitializers(ServletContextInitializer ... initializers) {
        Assert.notNull((Object)initializers, (String)"'initializers' must not be null");
        this.initializers.addAll(Arrays.asList(initializers));
    }

    public void setLocaleCharsetMappings(Map<Locale, Charset> localeCharsetMappings) {
        Assert.notNull(localeCharsetMappings, (String)"'localeCharsetMappings' must not be null");
        this.localeCharsetMappings = localeCharsetMappings;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        this.initParameters = initParameters;
    }

    public void setCookieSameSiteSuppliers(List<? extends CookieSameSiteSupplier> cookieSameSiteSuppliers) {
        Assert.notNull(cookieSameSiteSuppliers, (String)"'cookieSameSiteSuppliers' must not be null");
        this.cookieSameSiteSuppliers = new ArrayList<CookieSameSiteSupplier>(cookieSameSiteSuppliers);
    }

    public void addCookieSameSiteSuppliers(CookieSameSiteSupplier ... cookieSameSiteSuppliers) {
        Assert.notNull((Object)cookieSameSiteSuppliers, (String)"'cookieSameSiteSuppliers' must not be null");
        this.cookieSameSiteSuppliers.addAll(Arrays.asList(cookieSameSiteSuppliers));
    }

    public void addWebListenerClassNames(String ... webListenerClassNames) {
        this.webListenerClassNames.addAll(Arrays.asList(webListenerClassNames));
    }

    public Set<String> getWebListenerClassNames() {
        return this.webListenerClassNames;
    }

    public List<URL> getStaticResourceUrls() {
        return this.staticResourceJars.getUrls();
    }
}

