/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.autoconfigure;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="server.tomcat")
public class TomcatServerProperties {
    private @Nullable File basedir;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration backgroundProcessorDelay = Duration.ofSeconds(10L);
    private DataSize maxHttpFormPostSize = DataSize.ofMegabytes((long)2L);
    private DataSize maxPartHeaderSize = DataSize.ofBytes((long)512L);
    private int maxPartCount = 10;
    private DataSize maxSwallowSize = DataSize.ofMegabytes((long)2L);
    private Boolean redirectContextRoot = true;
    private boolean useRelativeRedirects;
    private Charset uriEncoding = StandardCharsets.UTF_8;
    private int maxConnections = 8192;
    private int acceptCount = 100;
    private int processorCache = 200;
    private @Nullable Duration keepAliveTimeout;
    private int maxKeepAliveRequests = 100;
    private List<String> additionalTldSkipPatterns = new ArrayList<String>();
    private List<Character> relaxedPathChars = new ArrayList<Character>();
    private List<Character> relaxedQueryChars = new ArrayList<Character>();
    private @Nullable Duration connectionTimeout;
    private DataSize maxHttpResponseHeaderSize = DataSize.ofKilobytes((long)8L);
    private int maxParameterCount = 1000;
    private UseApr useApr = UseApr.NEVER;
    private final Accesslog accesslog = new Accesslog();
    private final Threads threads = new Threads();
    private final Resource resource = new Resource();
    private final Mbeanregistry mbeanregistry = new Mbeanregistry();
    private final Remoteip remoteip = new Remoteip();

    public Duration getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    public void setBackgroundProcessorDelay(Duration backgroundProcessorDelay) {
        this.backgroundProcessorDelay = backgroundProcessorDelay;
    }

    public @Nullable File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(@Nullable File basedir) {
        this.basedir = basedir;
    }

    public Boolean getRedirectContextRoot() {
        return this.redirectContextRoot;
    }

    public void setRedirectContextRoot(Boolean redirectContextRoot) {
        this.redirectContextRoot = redirectContextRoot;
    }

    public boolean isUseRelativeRedirects() {
        return this.useRelativeRedirects;
    }

    public void setUseRelativeRedirects(boolean useRelativeRedirects) {
        this.useRelativeRedirects = useRelativeRedirects;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public DataSize getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    public void setMaxSwallowSize(DataSize maxSwallowSize) {
        this.maxSwallowSize = maxSwallowSize;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public void setAcceptCount(int acceptCount) {
        this.acceptCount = acceptCount;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public @Nullable Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(@Nullable Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public List<String> getAdditionalTldSkipPatterns() {
        return this.additionalTldSkipPatterns;
    }

    public void setAdditionalTldSkipPatterns(List<String> additionalTldSkipPatterns) {
        this.additionalTldSkipPatterns = additionalTldSkipPatterns;
    }

    public List<Character> getRelaxedPathChars() {
        return this.relaxedPathChars;
    }

    public void setRelaxedPathChars(List<Character> relaxedPathChars) {
        this.relaxedPathChars = relaxedPathChars;
    }

    public List<Character> getRelaxedQueryChars() {
        return this.relaxedQueryChars;
    }

    public void setRelaxedQueryChars(List<Character> relaxedQueryChars) {
        this.relaxedQueryChars = relaxedQueryChars;
    }

    public @Nullable Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(@Nullable Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public DataSize getMaxHttpResponseHeaderSize() {
        return this.maxHttpResponseHeaderSize;
    }

    public void setMaxHttpResponseHeaderSize(DataSize maxHttpResponseHeaderSize) {
        this.maxHttpResponseHeaderSize = maxHttpResponseHeaderSize;
    }

    public DataSize getMaxHttpFormPostSize() {
        return this.maxHttpFormPostSize;
    }

    public void setMaxHttpFormPostSize(DataSize maxHttpFormPostSize) {
        this.maxHttpFormPostSize = maxHttpFormPostSize;
    }

    public DataSize getMaxPartHeaderSize() {
        return this.maxPartHeaderSize;
    }

    public void setMaxPartHeaderSize(DataSize maxPartHeaderSize) {
        this.maxPartHeaderSize = maxPartHeaderSize;
    }

    public int getMaxPartCount() {
        return this.maxPartCount;
    }

    public void setMaxPartCount(int maxPartCount) {
        this.maxPartCount = maxPartCount;
    }

    public int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    public void setMaxParameterCount(int maxParameterCount) {
        this.maxParameterCount = maxParameterCount;
    }

    public UseApr getUseApr() {
        return this.useApr;
    }

    public void setUseApr(UseApr useApr) {
        this.useApr = useApr;
    }

    public Accesslog getAccesslog() {
        return this.accesslog;
    }

    public Threads getThreads() {
        return this.threads;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Mbeanregistry getMbeanregistry() {
        return this.mbeanregistry;
    }

    public Remoteip getRemoteip() {
        return this.remoteip;
    }

    public static enum UseApr {
        ALWAYS,
        WHEN_AVAILABLE,
        NEVER;

    }

    public static class Accesslog {
        private boolean enabled = false;
        private @Nullable String conditionIf;
        private @Nullable String conditionUnless;
        private String pattern = "common";
        private String directory = "logs";
        protected String prefix = "access_log";
        private String suffix = ".log";
        private @Nullable String encoding;
        private @Nullable String locale;
        private boolean checkExists = false;
        private boolean rotate = true;
        private boolean renameOnRotate = false;
        private int maxDays = -1;
        private String fileDateFormat = ".yyyy-MM-dd";
        private boolean ipv6Canonical = false;
        private boolean requestAttributesEnabled = false;
        private boolean buffered = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public @Nullable String getConditionIf() {
            return this.conditionIf;
        }

        public void setConditionIf(@Nullable String conditionIf) {
            this.conditionIf = conditionIf;
        }

        public @Nullable String getConditionUnless() {
            return this.conditionUnless;
        }

        public void setConditionUnless(@Nullable String conditionUnless) {
            this.conditionUnless = conditionUnless;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getDirectory() {
            return this.directory;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public @Nullable String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(@Nullable String encoding) {
            this.encoding = encoding;
        }

        public @Nullable String getLocale() {
            return this.locale;
        }

        public void setLocale(@Nullable String locale) {
            this.locale = locale;
        }

        public boolean isCheckExists() {
            return this.checkExists;
        }

        public void setCheckExists(boolean checkExists) {
            this.checkExists = checkExists;
        }

        public boolean isRotate() {
            return this.rotate;
        }

        public void setRotate(boolean rotate) {
            this.rotate = rotate;
        }

        public boolean isRenameOnRotate() {
            return this.renameOnRotate;
        }

        public void setRenameOnRotate(boolean renameOnRotate) {
            this.renameOnRotate = renameOnRotate;
        }

        public int getMaxDays() {
            return this.maxDays;
        }

        public void setMaxDays(int maxDays) {
            this.maxDays = maxDays;
        }

        public String getFileDateFormat() {
            return this.fileDateFormat;
        }

        public void setFileDateFormat(String fileDateFormat) {
            this.fileDateFormat = fileDateFormat;
        }

        public boolean isIpv6Canonical() {
            return this.ipv6Canonical;
        }

        public void setIpv6Canonical(boolean ipv6Canonical) {
            this.ipv6Canonical = ipv6Canonical;
        }

        public boolean isRequestAttributesEnabled() {
            return this.requestAttributesEnabled;
        }

        public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
            this.requestAttributesEnabled = requestAttributesEnabled;
        }

        public boolean isBuffered() {
            return this.buffered;
        }

        public void setBuffered(boolean buffered) {
            this.buffered = buffered;
        }
    }

    public static class Threads {
        private int max = 200;
        private int minSpare = 10;
        private int maxQueueCapacity = Integer.MAX_VALUE;

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public int getMinSpare() {
            return this.minSpare;
        }

        public void setMinSpare(int minSpare) {
            this.minSpare = minSpare;
        }

        public int getMaxQueueCapacity() {
            return this.maxQueueCapacity;
        }

        public void setMaxQueueCapacity(int maxQueueCapacity) {
            this.maxQueueCapacity = maxQueueCapacity;
        }
    }

    public static class Resource {
        private boolean allowCaching = true;
        private DataSize cacheMaxSize = DataSize.ofMegabytes((long)10L);
        private Duration cacheTtl = Duration.ofSeconds(5L);

        public boolean isAllowCaching() {
            return this.allowCaching;
        }

        public void setAllowCaching(boolean allowCaching) {
            this.allowCaching = allowCaching;
        }

        public DataSize getCacheMaxSize() {
            return this.cacheMaxSize;
        }

        public void setCacheMaxSize(DataSize cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
        }

        public Duration getCacheTtl() {
            return this.cacheTtl;
        }

        public void setCacheTtl(Duration cacheTtl) {
            this.cacheTtl = cacheTtl;
        }
    }

    public static class Mbeanregistry {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Remoteip {
        private String internalProxies = "192.168.0.0/16, 172.16.0.0/12, 169.254.0.0/16, fc00::/7, 10.0.0.0/8, 100.64.0.0/10, 127.0.0.0/8, fe80::/10, ::1/128";
        private @Nullable String protocolHeader;
        private String protocolHeaderHttpsValue = "https";
        private String hostHeader = "X-Forwarded-Host";
        private String portHeader = "X-Forwarded-Port";
        private @Nullable String remoteIpHeader;
        private @Nullable String trustedProxies;

        public String getInternalProxies() {
            return this.internalProxies;
        }

        public void setInternalProxies(String internalProxies) {
            this.internalProxies = internalProxies;
        }

        public @Nullable String getProtocolHeader() {
            return this.protocolHeader;
        }

        public void setProtocolHeader(@Nullable String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public String getProtocolHeaderHttpsValue() {
            return this.protocolHeaderHttpsValue;
        }

        public String getHostHeader() {
            return this.hostHeader;
        }

        public void setHostHeader(String hostHeader) {
            this.hostHeader = hostHeader;
        }

        public void setProtocolHeaderHttpsValue(String protocolHeaderHttpsValue) {
            this.protocolHeaderHttpsValue = protocolHeaderHttpsValue;
        }

        public String getPortHeader() {
            return this.portHeader;
        }

        public void setPortHeader(String portHeader) {
            this.portHeader = portHeader;
        }

        public @Nullable String getRemoteIpHeader() {
            return this.remoteIpHeader;
        }

        public void setRemoteIpHeader(@Nullable String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
        }

        public @Nullable String getTrustedProxies() {
            return this.trustedProxies;
        }

        public void setTrustedProxies(@Nullable String trustedProxies) {
            this.trustedProxies = trustedProxies;
        }
    }
}

