/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.assertj;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;

public class ApplicationContextAssert<C extends ApplicationContext>
extends AbstractAssert<ApplicationContextAssert<C>, C> {
    private final Throwable startupFailure;

    ApplicationContextAssert(C applicationContext, Throwable startupFailure) {
        super(applicationContext, ApplicationContextAssert.class);
        Assert.notNull(applicationContext, (String)"ApplicationContext must not be null");
        this.startupFailure = startupFailure;
    }

    public ApplicationContextAssert<C> hasBean(String name) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("to have bean named:%n <%s>", name));
        }
        if (this.findBean(name) == null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have bean named:%n <%s>%nbut found no such bean", new Object[]{this.getApplicationContext(), name}));
        }
        return this;
    }

    public ApplicationContextAssert<C> hasSingleBean(Class<?> type) {
        return this.hasSingleBean(type, Scope.INCLUDE_ANCESTORS);
    }

    public ApplicationContextAssert<C> hasSingleBean(Class<?> type, Scope scope) {
        String[] names;
        Assert.notNull((Object)((Object)scope), (String)"Scope must not be null");
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("to have a single bean of type:%n <%s>", type));
        }
        if ((names = scope.getBeanNamesForType((ApplicationContext)this.getApplicationContext(), type)).length == 0) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have a single bean of type:%n <%s>%nbut found no beans of that type", new Object[]{this.getApplicationContext(), type}));
        }
        if (names.length > 1) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have a single bean of type:%n <%s>%nbut found:%n <%s>", new Object[]{this.getApplicationContext(), type, names}));
        }
        return this;
    }

    public ApplicationContextAssert<C> doesNotHaveBean(Class<?> type) {
        return this.doesNotHaveBean(type, Scope.INCLUDE_ANCESTORS);
    }

    public ApplicationContextAssert<C> doesNotHaveBean(Class<?> type, Scope scope) {
        String[] names;
        Assert.notNull((Object)((Object)scope), (String)"Scope must not be null");
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("not to have any beans of type:%n <%s>", type));
        }
        if ((names = scope.getBeanNamesForType((ApplicationContext)this.getApplicationContext(), type)).length > 0) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nnot to have a beans of type:%n <%s>%nbut found:%n <%s>", new Object[]{this.getApplicationContext(), type, names}));
        }
        return this;
    }

    public ApplicationContextAssert<C> doesNotHaveBean(String name) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("not to have any beans of name:%n <%s>", name));
        }
        try {
            Object bean = this.getApplicationContext().getBean(name);
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nnot to have a bean of name:%n <%s>%nbut found:%n <%s>", new Object[]{this.getApplicationContext(), name, bean}));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return this;
    }

    public <T> AbstractObjectArrayAssert<?, String> getBeanNames(Class<T> type) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("to get beans names with type:%n <%s>", type));
        }
        return Assertions.assertThat((Object[])this.getApplicationContext().getBeanNamesForType(type)).as("Bean names of type <%s> from <%s>", new Object[]{type, this.getApplicationContext()});
    }

    public <T> AbstractObjectAssert<?, T> getBean(Class<T> type) {
        return this.getBean(type, Scope.INCLUDE_ANCESTORS);
    }

    public <T> AbstractObjectAssert<?, T> getBean(Class<T> type, Scope scope) {
        String[] names;
        String name;
        Assert.notNull((Object)((Object)scope), (String)"Scope must not be null");
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("to contain bean of type:%n <%s>", type));
        }
        String string = name = (names = scope.getBeanNamesForType((ApplicationContext)this.getApplicationContext(), type)).length > 0 ? this.getPrimary(names, scope) : null;
        if (names.length > 1 && name == null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nsingle bean of type:%n <%s>%nbut found:%n <%s>", new Object[]{this.getApplicationContext(), type, names}));
        }
        Object bean = name != null ? this.getApplicationContext().getBean(name, type) : null;
        return Assertions.assertThat(bean).as("Bean of type <%s> from <%s>", new Object[]{type, this.getApplicationContext()});
    }

    private String getPrimary(String[] names, Scope scope) {
        if (names.length == 1) {
            return names[0];
        }
        String primary = null;
        for (String name : names) {
            if (!this.isPrimary(name, scope)) continue;
            if (primary != null) {
                return null;
            }
            primary = name;
        }
        return primary;
    }

    private boolean isPrimary(String name, Scope scope) {
        Object context = this.getApplicationContext();
        while (context != null) {
            ConfigurableListableBeanFactory factory;
            if (context instanceof ConfigurableApplicationContext && (factory = ((ConfigurableApplicationContext)context).getBeanFactory()).containsBean(name) && factory.getMergedBeanDefinition(name).isPrimary()) {
                return true;
            }
            context = scope != Scope.NO_ANCESTORS ? context.getParent() : null;
        }
        return false;
    }

    public AbstractObjectAssert<?, Object> getBean(String name) {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("to contain a bean of name:%n <%s>", name));
        }
        Object bean = this.findBean(name);
        return Assertions.assertThat((Object)bean).as("Bean of name <%s> from <%s>", new Object[]{name, this.getApplicationContext()});
    }

    public <T> AbstractObjectAssert<?, T> getBean(String name, Class<T> type) {
        Object bean;
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("to contain a bean of name:%n <%s> (%s)", name, type));
        }
        if ((bean = this.findBean(name)) != null && type != null && !type.isInstance(bean)) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto contain a bean of name:%n <%s> (%s)%nbut found:%n <%s> of type <%s>", new Object[]{this.getApplicationContext(), name, type, bean, bean.getClass()}));
        }
        return Assertions.assertThat((Object)bean).as("Bean of name <%s> and type <%s> from <%s>", new Object[]{name, type, this.getApplicationContext()});
    }

    private Object findBean(String name) {
        try {
            return this.getApplicationContext().getBean(name);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    public <T> MapAssert<String, T> getBeans(Class<T> type) {
        return this.getBeans(type, Scope.INCLUDE_ANCESTORS);
    }

    public <T> MapAssert<String, T> getBeans(Class<T> type, Scope scope) {
        Assert.notNull((Object)((Object)scope), (String)"Scope must not be null");
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("to get beans of type:%n <%s>", type));
        }
        return (MapAssert)Assertions.assertThat(scope.getBeansOfType((ApplicationContext)this.getApplicationContext(), type)).as("Beans of type <%s> from <%s>", new Object[]{type, this.getApplicationContext()});
    }

    public AbstractThrowableAssert<?, ? extends Throwable> getFailure() {
        this.hasFailed();
        return Assertions.assertThat((Throwable)this.startupFailure);
    }

    public ApplicationContextAssert<C> hasFailed() {
        if (this.startupFailure == null) {
            this.throwAssertionError((ErrorMessageFactory)new BasicErrorMessageFactory("%nExpecting:%n <%s>%nto have failed%nbut context started successfully", new Object[]{this.getApplicationContext()}));
        }
        return this;
    }

    public ApplicationContextAssert<C> hasNotFailed() {
        if (this.startupFailure != null) {
            this.throwAssertionError((ErrorMessageFactory)this.contextFailedToStartWhenExpecting("to have not failed", new Object[0]));
        }
        return this;
    }

    protected final C getApplicationContext() {
        return (C)((ApplicationContext)this.actual);
    }

    protected final Throwable getStartupFailure() {
        return this.startupFailure;
    }

    private ContextFailedToStart<C> contextFailedToStartWhenExpecting(String expectationFormat, Object ... arguments) {
        return new ContextFailedToStart((ApplicationContext)this.getApplicationContext(), this.startupFailure, expectationFormat, arguments, null);
    }

    private static final class ContextFailedToStart<C extends ApplicationContext>
    extends BasicErrorMessageFactory {
        private ContextFailedToStart(C context, Throwable ex, String expectationFormat, Object ... arguments) {
            super("%nExpecting:%n <%s>%n" + expectationFormat + ":%nbut context failed to start:%n%s", ContextFailedToStart.combineArguments(context.toString(), ex, arguments));
        }

        private static Object[] combineArguments(String context, Throwable ex, Object[] arguments) {
            Object[] combinedArguments = new Object[arguments.length + 2];
            combinedArguments[0] = ContextFailedToStart.unquotedString((String)context);
            System.arraycopy(arguments, 0, combinedArguments, 1, arguments.length);
            combinedArguments[combinedArguments.length - 1] = ContextFailedToStart.unquotedString((String)ContextFailedToStart.getIndentedStackTraceAsString(ex));
            return combinedArguments;
        }

        private static String getIndentedStackTraceAsString(Throwable ex) {
            String stackTrace = ContextFailedToStart.getStackTraceAsString(ex);
            return ContextFailedToStart.indent(stackTrace);
        }

        private static String getStackTraceAsString(Throwable ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            return writer.toString();
        }

        private static String indent(String input) {
            BufferedReader reader = new BufferedReader(new StringReader(input));
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            reader.lines().forEach(line -> {
                printer.print(" ");
                printer.println((String)line);
            });
            return writer.toString();
        }

        /* synthetic */ ContextFailedToStart(ApplicationContext x0, Throwable x1, String x2, Object[] x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }

    public static enum Scope {
        NO_ANCESTORS{

            @Override
            String[] getBeanNamesForType(ApplicationContext applicationContext, Class<?> type) {
                return applicationContext.getBeanNamesForType(type);
            }

            @Override
            <T> Map<String, T> getBeansOfType(ApplicationContext applicationContext, Class<T> type) {
                return applicationContext.getBeansOfType(type);
            }
        }
        ,
        INCLUDE_ANCESTORS{

            @Override
            String[] getBeanNamesForType(ApplicationContext applicationContext, Class<?> type) {
                return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)applicationContext, type);
            }

            @Override
            <T> Map<String, T> getBeansOfType(ApplicationContext applicationContext, Class<T> type) {
                return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, type);
            }
        };


        abstract String[] getBeanNamesForType(ApplicationContext var1, Class<?> var2);

        abstract <T> Map<String, T> getBeansOfType(ApplicationContext var1, Class<T> var2);
    }
}

