/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.restdocs;

import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.restdocs.ManualRestDocumentation;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;

public class RestDocsTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String REST_DOCS_CLASS = "org.springframework.restdocs.ManualRestDocumentation";

    public int getOrder() {
        return 2147483547;
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (this.restDocsIsPresent()) {
            new DocumentationHandler().beforeTestMethod(testContext);
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        if (this.restDocsIsPresent()) {
            new DocumentationHandler().afterTestMethod(testContext);
        }
    }

    private boolean restDocsIsPresent() {
        return ClassUtils.isPresent((String)REST_DOCS_CLASS, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    private static class DocumentationHandler {
        private DocumentationHandler() {
        }

        private void beforeTestMethod(TestContext testContext) {
            ManualRestDocumentation restDocumentation = this.findManualRestDocumentation(testContext);
            if (restDocumentation != null) {
                restDocumentation.beforeTest(testContext.getTestClass(), testContext.getTestMethod().getName());
            }
        }

        private void afterTestMethod(TestContext testContext) {
            ManualRestDocumentation restDocumentation = this.findManualRestDocumentation(testContext);
            if (restDocumentation != null) {
                restDocumentation.afterTest();
            }
        }

        private ManualRestDocumentation findManualRestDocumentation(TestContext testContext) {
            try {
                return (ManualRestDocumentation)testContext.getApplicationContext().getBean(ManualRestDocumentation.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return null;
            }
        }
    }
}

