/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet.actuate.web.mappings;

import jakarta.servlet.ServletContext;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.web.mappings.MappingDescriptionProvider;
import org.springframework.boot.servlet.actuate.web.mappings.FilterRegistrationMappingDescription;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

@ImportRuntimeHints(value={FiltersMappingDescriptionProviderRuntimeHints.class})
public class FiltersMappingDescriptionProvider
implements MappingDescriptionProvider {
    public List<FilterRegistrationMappingDescription> describeMappings(ApplicationContext context) {
        if (context instanceof WebApplicationContext) {
            WebApplicationContext webApplicationContext = (WebApplicationContext)context;
            ServletContext servletContext = webApplicationContext.getServletContext();
            Assert.state((servletContext != null ? 1 : 0) != 0, (String)"'servletContext' must not be null");
            return servletContext.getFilterRegistrations().values().stream().map(FilterRegistrationMappingDescription::new).toList();
        }
        return Collections.emptyList();
    }

    public String getMappingName() {
        return "servletFilters";
    }

    static class FiltersMappingDescriptionProviderRuntimeHints
    implements RuntimeHintsRegistrar {
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        FiltersMappingDescriptionProviderRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{FilterRegistrationMappingDescription.class});
        }
    }
}

