/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet.autoconfigure.actuate;

import org.springframework.boot.actuate.autoconfigure.web.exchanges.HttpExchangesProperties;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.servlet.actuate.exchanges.HttpExchangesFilter;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBooleanProperty(name={"management.httpexchanges.recording.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={HttpExchangeRepository.class})
@EnableConfigurationProperties(value={HttpExchangesProperties.class})
public class ServletHttpExchangesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    HttpExchangesFilter httpExchangesFilter(HttpExchangeRepository repository, HttpExchangesProperties properties) {
        return new HttpExchangesFilter(repository, properties.getRecording().getInclude());
    }
}

