/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet.actuate.mappings;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.web.mappings.MappingDescriptionProvider;
import org.springframework.boot.servlet.actuate.mappings.ServletRegistrationMappingDescription;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.web.context.WebApplicationContext;

@ImportRuntimeHints(value={ServletsMappingDescriptionProviderRuntimeHints.class})
public class ServletsMappingDescriptionProvider
implements MappingDescriptionProvider {
    public List<ServletRegistrationMappingDescription> describeMappings(ApplicationContext context) {
        if (context instanceof WebApplicationContext) {
            WebApplicationContext webApplicationContext = (WebApplicationContext)context;
            return webApplicationContext.getServletContext().getServletRegistrations().values().stream().map(ServletRegistrationMappingDescription::new).toList();
        }
        return Collections.emptyList();
    }

    public String getMappingName() {
        return "servlets";
    }

    static class ServletsMappingDescriptionProviderRuntimeHints
    implements RuntimeHintsRegistrar {
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        ServletsMappingDescriptionProviderRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{ServletRegistrationMappingDescription.class});
        }
    }
}

