/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet.actuate.exchanges;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.springframework.boot.actuate.web.exchanges.HttpExchange;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.actuate.web.exchanges.Include;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpRequest;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpResponse;
import org.springframework.boot.servlet.actuate.exchanges.RecordableServletHttpRequest;
import org.springframework.boot.servlet.actuate.exchanges.RecordableServletHttpResponse;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpExchangesFilter
extends OncePerRequestFilter
implements Ordered {
    private int order = 0x7FFFFFF5;
    private final HttpExchangeRepository repository;
    private final Set<Include> includes;

    public HttpExchangesFilter(HttpExchangeRepository repository, Set<Include> includes) {
        this.repository = repository;
        this.includes = includes;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.isRequestValid(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RecordableServletHttpRequest sourceRequest = new RecordableServletHttpRequest(request);
        HttpExchange.Started startedHttpExchange = HttpExchange.start((RecordableHttpRequest)sourceRequest);
        int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            status = response.getStatus();
        }
        finally {
            RecordableServletHttpResponse sourceResponse = new RecordableServletHttpResponse(response, status);
            HttpExchange finishedExchange = startedHttpExchange.finish((RecordableHttpResponse)sourceResponse, () -> ((HttpServletRequest)request).getUserPrincipal(), () -> this.getSessionId(request), this.includes);
            this.repository.add(finishedExchange);
        }
    }

    private boolean isRequestValid(HttpServletRequest request) {
        try {
            new URI(request.getRequestURL().toString());
            return true;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    private String getSessionId(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null ? session.getId() : null;
    }
}

