/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.actuate.servlet;

import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointAutoConfiguration;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.security.autoconfigure.ConditionalOnDefaultWebSecurity;
import org.springframework.boot.security.autoconfigure.actuate.servlet.EndpointRequest;
import org.springframework.boot.security.autoconfigure.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;

@AutoConfiguration(before={SecurityAutoConfiguration.class}, afterName={"org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={RequestMatcher.class, WebEndpointAutoConfiguration.class})
@ConditionalOnDefaultWebSecurity
public class ManagementWebSecurityAutoConfiguration {
    @Bean
    @Order(value=0x7FFFFFFA)
    SecurityFilterChain managementSecurityFilterChain(Environment environment, HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(requests -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{this.healthMatcher(), this.additionalHealthPathsMatcher()})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated();
        });
        if (ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", null)) {
            http.cors(Customizer.withDefaults());
        }
        http.formLogin(Customizer.withDefaults());
        http.httpBasic(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }

    private RequestMatcher healthMatcher() {
        return EndpointRequest.to(HealthEndpoint.class);
    }

    private RequestMatcher additionalHealthPathsMatcher() {
        return EndpointRequest.toAdditionalPaths(WebServerNamespace.SERVER, HealthEndpoint.class);
    }
}

