/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.client.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.security.oauth2.client")
public class OAuth2ClientProperties
implements InitializingBean {
    private final Map<String, Provider> provider = new HashMap<String, Provider>();
    private final Map<String, Registration> registration = new HashMap<String, Registration>();

    public Map<String, Provider> getProvider() {
        return this.provider;
    }

    public Map<String, Registration> getRegistration() {
        return this.registration;
    }

    public void afterPropertiesSet() {
        this.validate();
    }

    public void validate() {
        this.getRegistration().forEach(this::validateRegistration);
    }

    private void validateRegistration(String id, Registration registration) {
        if (!StringUtils.hasText((String)registration.getClientId())) {
            throw new IllegalStateException("Client id of registration '%s' must not be empty.".formatted(id));
        }
    }

    public static class Registration {
        private @Nullable String provider;
        private @Nullable String clientId;
        private @Nullable String clientSecret;
        private @Nullable String clientAuthenticationMethod;
        private @Nullable String authorizationGrantType;
        private @Nullable String redirectUri;
        private @Nullable Set<String> scope;
        private @Nullable String clientName;

        public @Nullable String getProvider() {
            return this.provider;
        }

        public void setProvider(@Nullable String provider) {
            this.provider = provider;
        }

        public @Nullable String getClientId() {
            return this.clientId;
        }

        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        public @Nullable String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(@Nullable String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public @Nullable String getClientAuthenticationMethod() {
            return this.clientAuthenticationMethod;
        }

        public void setClientAuthenticationMethod(@Nullable String clientAuthenticationMethod) {
            this.clientAuthenticationMethod = clientAuthenticationMethod;
        }

        public @Nullable String getAuthorizationGrantType() {
            return this.authorizationGrantType;
        }

        public void setAuthorizationGrantType(@Nullable String authorizationGrantType) {
            this.authorizationGrantType = authorizationGrantType;
        }

        public @Nullable String getRedirectUri() {
            return this.redirectUri;
        }

        public void setRedirectUri(@Nullable String redirectUri) {
            this.redirectUri = redirectUri;
        }

        public @Nullable Set<String> getScope() {
            return this.scope;
        }

        public void setScope(@Nullable Set<String> scope) {
            this.scope = scope;
        }

        public @Nullable String getClientName() {
            return this.clientName;
        }

        public void setClientName(@Nullable String clientName) {
            this.clientName = clientName;
        }
    }

    public static class Provider {
        private @Nullable String authorizationUri;
        private @Nullable String tokenUri;
        private @Nullable String userInfoUri;
        private @Nullable String userInfoAuthenticationMethod;
        private @Nullable String userNameAttribute;
        private @Nullable String jwkSetUri;
        private @Nullable String issuerUri;

        public @Nullable String getAuthorizationUri() {
            return this.authorizationUri;
        }

        public void setAuthorizationUri(@Nullable String authorizationUri) {
            this.authorizationUri = authorizationUri;
        }

        public @Nullable String getTokenUri() {
            return this.tokenUri;
        }

        public void setTokenUri(@Nullable String tokenUri) {
            this.tokenUri = tokenUri;
        }

        public @Nullable String getUserInfoUri() {
            return this.userInfoUri;
        }

        public void setUserInfoUri(@Nullable String userInfoUri) {
            this.userInfoUri = userInfoUri;
        }

        public @Nullable String getUserInfoAuthenticationMethod() {
            return this.userInfoAuthenticationMethod;
        }

        public void setUserInfoAuthenticationMethod(@Nullable String userInfoAuthenticationMethod) {
            this.userInfoAuthenticationMethod = userInfoAuthenticationMethod;
        }

        public @Nullable String getUserNameAttribute() {
            return this.userNameAttribute;
        }

        public void setUserNameAttribute(@Nullable String userNameAttribute) {
            this.userNameAttribute = userNameAttribute;
        }

        public @Nullable String getJwkSetUri() {
            return this.jwkSetUri;
        }

        public void setJwkSetUri(@Nullable String jwkSetUri) {
            this.jwkSetUri = jwkSetUri;
        }

        public @Nullable String getIssuerUri() {
            return this.issuerUri;
        }

        public void setIssuerUri(@Nullable String issuerUri) {
            this.issuerUri = issuerUri;
        }
    }
}

