/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.client.autoconfigure;

import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.security.oauth2.client.autoconfigure.ConditionalOnOAuth2ClientRegistrationProperties;
import org.springframework.boot.security.oauth2.client.autoconfigure.OAuth2ClientProperties;
import org.springframework.boot.security.oauth2.client.autoconfigure.OAuth2ClientPropertiesMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;

class OAuth2ClientConfigurations {
    OAuth2ClientConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ClientRegistrationRepository.class})
    static class OAuth2AuthorizedClientServiceConfiguration {
        OAuth2AuthorizedClientServiceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
            return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnOAuth2ClientRegistrationProperties
    @EnableConfigurationProperties(value={OAuth2ClientProperties.class})
    @ConditionalOnMissingBean(value={ClientRegistrationRepository.class})
    static class ClientRegistrationRepositoryConfiguration {
        ClientRegistrationRepositoryConfiguration() {
        }

        @Bean
        InMemoryClientRegistrationRepository clientRegistrationRepository(OAuth2ClientProperties properties) {
            ArrayList<ClientRegistration> registrations = new ArrayList<ClientRegistration>(new OAuth2ClientPropertiesMapper(properties).asClientRegistrations().values());
            return new InMemoryClientRegistrationRepository(registrations);
        }
    }
}

