/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.r2dbc.docker.compose.ConnectionFactoryOptionsBuilder;
import org.springframework.boot.r2dbc.docker.compose.MySqlEnvironment;

class MySqlR2dbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<R2dbcConnectionDetails> {
    MySqlR2dbcDockerComposeConnectionDetailsFactory() {
        super("mysql", new String[]{"io.r2dbc.spi.ConnectionFactoryOptions"});
    }

    protected R2dbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new MySqlR2dbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class MySqlR2dbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements R2dbcConnectionDetails {
        private static final ConnectionFactoryOptionsBuilder connectionFactoryOptionsBuilder = new ConnectionFactoryOptionsBuilder("mysql", 3306);
        private final ConnectionFactoryOptions connectionFactoryOptions;

        MySqlR2dbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            MySqlEnvironment environment = new MySqlEnvironment(service.env());
            this.connectionFactoryOptions = connectionFactoryOptionsBuilder.build(service, environment.getDatabase(), environment.getUsername(), environment.getPassword());
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return this.connectionFactoryOptions;
        }
    }
}

