/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ClickHouseEnvironment {
    private final String username;
    private final String password;
    private final String database;

    ClickHouseEnvironment(Map<String, @Nullable String> env) {
        this.username = ClickHouseEnvironment.extractUsername(env);
        this.password = this.extractPassword(env);
        this.database = ClickHouseEnvironment.extractDatabase(env);
    }

    private static String extractDatabase(Map<String, @Nullable String> env) {
        String result = env.get("CLICKHOUSE_DB");
        return result != null ? result : "default";
    }

    private static String extractUsername(Map<String, @Nullable String> env) {
        String result = env.get("CLICKHOUSE_USER");
        return result != null ? result : "default";
    }

    private String extractPassword(Map<String, @Nullable String> env) {
        boolean allowEmpty = env.containsKey("ALLOW_EMPTY_PASSWORD");
        String password = env.get("CLICKHOUSE_PASSWORD");
        Assert.state((StringUtils.hasLength((String)password) || allowEmpty ? 1 : 0) != 0, (String)"No ClickHouse password found");
        return password != null ? password : "";
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

