/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.autoconfigure;

import io.r2dbc.spi.ConnectionFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.r2dbc.ConnectionFactoryBuilder;
import org.springframework.boot.r2dbc.autoconfigure.ApplicationR2dbcScriptDatabaseInitializer;
import org.springframework.boot.sql.autoconfigure.init.ConditionalOnSqlInitialization;
import org.springframework.boot.sql.autoconfigure.init.SqlInitializationProperties;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.r2dbc.connection.init.DatabasePopulator;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={ConnectionFactory.class, DatabasePopulator.class})
@ConditionalOnSingleCandidate(value=ConnectionFactory.class)
@ConditionalOnMissingBean(value={ApplicationR2dbcScriptDatabaseInitializer.class}, type={"org.springframework.boot.jdbc.autoconfigure.ApplicationDataSourceScriptDatabaseInitializer"})
@ConditionalOnSqlInitialization
@Import(value={DatabaseInitializationDependencyConfigurer.class})
@EnableConfigurationProperties(value={SqlInitializationProperties.class})
public final class R2dbcInitializationAutoConfiguration {
    @Bean
    ApplicationR2dbcScriptDatabaseInitializer r2dbcScriptDatabaseInitializer(ConnectionFactory connectionFactory, SqlInitializationProperties properties) {
        return new ApplicationR2dbcScriptDatabaseInitializer(R2dbcInitializationAutoConfiguration.determineConnectionFactory(connectionFactory, properties.getUsername(), properties.getPassword()), properties);
    }

    private static ConnectionFactory determineConnectionFactory(ConnectionFactory connectionFactory, @Nullable String username, @Nullable String password) {
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            return ConnectionFactoryBuilder.derivedFrom(connectionFactory).username(username).password(password).build();
        }
        return connectionFactory;
    }
}

