/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j.health;

import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.neo4j.health.Neo4jHealthDetails;
import org.springframework.util.StringUtils;

class Neo4jHealthDetailsHandler {
    Neo4jHealthDetailsHandler() {
    }

    void addHealthDetails(Health.Builder builder, Neo4jHealthDetails healthDetails) {
        ResultSummary summary = healthDetails.getSummary();
        ServerInfo serverInfo = summary.server();
        builder.up().withDetail("server", (Object)(healthDetails.getVersion() + "@" + serverInfo.address())).withDetail("edition", (Object)healthDetails.getEdition());
        DatabaseInfo databaseInfo = summary.database();
        if (StringUtils.hasText((String)databaseInfo.name())) {
            builder.withDetail("database", (Object)databaseInfo.name());
        }
    }
}

