/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.observation.autoconfigure;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationHandlerGroup;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;

class ObservationHandlerGroups {
    private final List<ObservationHandlerGroup> groups;

    ObservationHandlerGroups(Collection<? extends ObservationHandlerGroup> groups) {
        this.groups = Collections.unmodifiableList(ObservationHandlerGroups.sort(groups));
    }

    private static List<ObservationHandlerGroup> sort(Collection<? extends ObservationHandlerGroup> groups) {
        ArrayList<ObservationHandlerGroup> sortedGroups = new ArrayList<ObservationHandlerGroup>(groups);
        Collections.sort(sortedGroups);
        return sortedGroups;
    }

    void register(ObservationRegistry.ObservationConfig config, List<ObservationHandler<?>> handlers) {
        LinkedMultiValueMap grouped = new LinkedMultiValueMap();
        ArrayList unclaimed = new ArrayList();
        for (ObservationHandler<?> observationHandler : handlers) {
            ObservationHandlerGroup group = this.findGroup(observationHandler);
            if (group == null) {
                unclaimed.add(observationHandler);
                continue;
            }
            grouped.add((Object)group, observationHandler);
        }
        for (ObservationHandlerGroup observationHandlerGroup : this.groups) {
            List members = (List)grouped.get((Object)observationHandlerGroup);
            if (CollectionUtils.isEmpty((Collection)members)) continue;
            observationHandlerGroup.registerMembers(config, members);
        }
        if (!CollectionUtils.isEmpty(unclaimed)) {
            for (ObservationHandler observationHandler : unclaimed) {
                config.observationHandler(observationHandler);
            }
        }
    }

    private @Nullable ObservationHandlerGroup findGroup(ObservationHandler<?> handler) {
        for (ObservationHandlerGroup group : this.groups) {
            if (!group.isMember(handler)) continue;
            return group;
        }
        return null;
    }
}

