/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.jspecify.annotations.Nullable;

class RunArguments {
    private static final String[] NO_ARGS = new String[0];
    private final Deque<String> args = new LinkedList<String>();

    RunArguments(@Nullable String arguments) {
        this(RunArguments.parseArgs(arguments));
    }

    RunArguments(@Nullable String[] args) {
        this(args != null ? Arrays.asList(args) : null);
    }

    RunArguments(@Nullable Iterable<@Nullable String> args) {
        if (args != null) {
            for (String arg : args) {
                if (arg == null) continue;
                this.args.add(arg);
            }
        }
    }

    Deque<String> getArgs() {
        return this.args;
    }

    String[] asArray() {
        return this.args.toArray(new String[0]);
    }

    static String[] parseArgs(@Nullable String arguments) {
        if (arguments == null || arguments.trim().isEmpty()) {
            return NO_ARGS;
        }
        try {
            arguments = arguments.replace('\n', ' ').replace('\t', ' ');
            return CommandLineUtils.translateCommandline((String)arguments);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to parse arguments [" + arguments + "]", ex);
        }
    }
}

