/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;

public class Docker {
    private String host;
    private String context;
    private boolean tlsVerify;
    private String certPath;
    private boolean bindHostToBuilder;
    private DockerRegistry builderRegistry;
    private DockerRegistry publishRegistry;

    public String getHost() {
        return this.host;
    }

    void setHost(String host) {
        this.host = host;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isTlsVerify() {
        return this.tlsVerify;
    }

    void setTlsVerify(boolean tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    public String getCertPath() {
        return this.certPath;
    }

    void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public boolean isBindHostToBuilder() {
        return this.bindHostToBuilder;
    }

    void setBindHostToBuilder(boolean bindHostToBuilder) {
        this.bindHostToBuilder = bindHostToBuilder;
    }

    DockerRegistry getBuilderRegistry() {
        return this.builderRegistry;
    }

    void setBuilderRegistry(DockerRegistry builderRegistry) {
        this.builderRegistry = builderRegistry;
    }

    DockerRegistry getPublishRegistry() {
        return this.publishRegistry;
    }

    void setPublishRegistry(DockerRegistry builderRegistry) {
        this.publishRegistry = builderRegistry;
    }

    DockerConfiguration asDockerConfiguration(boolean publish) {
        DockerConfiguration dockerConfiguration = new DockerConfiguration();
        dockerConfiguration = this.customizeHost(dockerConfiguration);
        dockerConfiguration = dockerConfiguration.withBindHostToBuilder(this.bindHostToBuilder);
        dockerConfiguration = this.customizeBuilderAuthentication(dockerConfiguration);
        dockerConfiguration = this.customizePublishAuthentication(dockerConfiguration, publish);
        return dockerConfiguration;
    }

    private DockerConfiguration customizeHost(DockerConfiguration dockerConfiguration) {
        if (this.context != null && this.host != null) {
            throw new IllegalArgumentException("Invalid Docker configuration, either context or host can be provided but not both");
        }
        if (this.context != null) {
            return dockerConfiguration.withContext(this.context);
        }
        if (this.host != null) {
            return dockerConfiguration.withHost(this.host, this.tlsVerify, this.certPath);
        }
        return dockerConfiguration;
    }

    private DockerConfiguration customizeBuilderAuthentication(DockerConfiguration dockerConfiguration) {
        if (this.builderRegistry == null || this.builderRegistry.isEmpty()) {
            return dockerConfiguration;
        }
        if (this.builderRegistry.hasTokenAuth() && !this.builderRegistry.hasUserAuth()) {
            return dockerConfiguration.withBuilderRegistryTokenAuthentication(this.builderRegistry.getToken());
        }
        if (this.builderRegistry.hasUserAuth() && !this.builderRegistry.hasTokenAuth()) {
            return dockerConfiguration.withBuilderRegistryUserAuthentication(this.builderRegistry.getUsername(), this.builderRegistry.getPassword(), this.builderRegistry.getUrl(), this.builderRegistry.getEmail());
        }
        throw new IllegalArgumentException("Invalid Docker builder registry configuration, either token or username/password must be provided");
    }

    private DockerConfiguration customizePublishAuthentication(DockerConfiguration dockerConfiguration, boolean publish) {
        if (!publish) {
            return dockerConfiguration;
        }
        if (this.publishRegistry == null || this.publishRegistry.isEmpty()) {
            return dockerConfiguration.withEmptyPublishRegistryAuthentication();
        }
        if (this.publishRegistry.hasTokenAuth() && !this.publishRegistry.hasUserAuth()) {
            return dockerConfiguration.withPublishRegistryTokenAuthentication(this.publishRegistry.getToken());
        }
        if (this.publishRegistry.hasUserAuth() && !this.publishRegistry.hasTokenAuth()) {
            return dockerConfiguration.withPublishRegistryUserAuthentication(this.publishRegistry.getUsername(), this.publishRegistry.getPassword(), this.publishRegistry.getUrl(), this.publishRegistry.getEmail());
        }
        throw new IllegalArgumentException("Invalid Docker publish registry configuration, either token or username/password must be provided");
    }

    public static class DockerRegistry {
        private String username;
        private String password;
        private String url;
        private String email;
        private String token;

        public DockerRegistry() {
        }

        public DockerRegistry(String username, String password, String url, String email) {
            this.username = username;
            this.password = password;
            this.url = url;
            this.email = email;
        }

        public DockerRegistry(String token) {
            this.token = token;
        }

        public String getUsername() {
            return this.username;
        }

        void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        void setPassword(String password) {
            this.password = password;
        }

        public String getEmail() {
            return this.email;
        }

        void setEmail(String email) {
            this.email = email;
        }

        String getUrl() {
            return this.url;
        }

        void setUrl(String url) {
            this.url = url;
        }

        public String getToken() {
            return this.token;
        }

        void setToken(String token) {
            this.token = token;
        }

        boolean isEmpty() {
            return this.username == null && this.password == null && this.url == null && this.email == null && this.token == null;
        }

        boolean hasTokenAuth() {
            return this.token != null;
        }

        boolean hasUserAuth() {
            return this.username != null && this.password != null;
        }
    }
}

