/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.util.StreamUtils;

final class SizeCalculatingEntryWriter
implements EntryWriter {
    static final int THRESHOLD = 20480;
    private final Object content;
    private final int size;

    private SizeCalculatingEntryWriter(EntryWriter entryWriter) throws IOException {
        SizeCalculatingOutputStream outputStream;
        try (SizeCalculatingOutputStream sizeCalculatingOutputStream = outputStream = new SizeCalculatingOutputStream();){
            entryWriter.write(outputStream);
        }
        this.content = outputStream.getContent();
        this.size = outputStream.getSize();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.getContentInputStream();
        this.copy(inputStream, outputStream);
    }

    private InputStream getContentInputStream() throws FileNotFoundException {
        Object object = this.content;
        if (object instanceof File) {
            File file = (File)object;
            return new FileInputStream(file);
        }
        return new ByteArrayInputStream((byte[])this.content);
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (InputStream inputStream2 = inputStream;){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    static EntryWriter get(EntryWriter entryWriter) throws IOException {
        if (entryWriter == null || entryWriter.size() != -1) {
            return entryWriter;
        }
        return new SizeCalculatingEntryWriter(entryWriter);
    }

    private static class SizeCalculatingOutputStream
    extends OutputStream {
        private int size;
        private File tempFile;
        private OutputStream outputStream = new ByteArrayOutputStream();

        SizeCalculatingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream outputStream;
            int updatedSize = this.size + len;
            if (updatedSize > 20480 && (outputStream = this.outputStream) instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)outputStream;
                this.outputStream = this.convertToFileOutputStream(byteArrayOutputStream);
            }
            this.outputStream.write(b, off, len);
            this.size = updatedSize;
        }

        private OutputStream convertToFileOutputStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            this.initializeTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);
            StreamUtils.copy((byte[])byteArrayOutputStream.toByteArray(), (OutputStream)fileOutputStream);
            return fileOutputStream;
        }

        private void initializeTempFile() throws IOException {
            if (this.tempFile == null) {
                this.tempFile = File.createTempFile("springboot-", "-entrycontent");
                this.tempFile.deleteOnExit();
            }
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        Object getContent() {
            Object object;
            OutputStream outputStream = this.outputStream;
            if (outputStream instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)outputStream;
                object = byteArrayOutputStream.toByteArray();
            } else {
                object = this.tempFile;
            }
            return object;
        }

        int getSize() {
            return this.size;
        }
    }
}

