/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ldap.docker.compose;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.ldap.autoconfigure.LdapConnectionDetails;

class LLdapDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<LdapConnectionDetails> {
    LLdapDockerComposeConnectionDetailsFactory() {
        super("lldap/lldap", new String[0]);
    }

    protected LdapConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new LLdapDockerComposeConnectionDetails(source.getRunningService());
    }

    static class LLdapDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements LdapConnectionDetails {
        private final String[] urls;
        private final String base;
        private final String username;
        private final String password;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        LLdapDockerComposeConnectionDetails(RunningService service) {
            super(service);
            @Nullable Map env = service.env();
            boolean usesTls = Boolean.parseBoolean(env.getOrDefault("LLDAP_LDAPS_OPTIONS__ENABLED", "false"));
            String ldapPort = usesTls ? LLdapDockerComposeConnectionDetails.getFromEnv(env, "LLDAP_LDAPS_OPTIONS__PORT", "6360") : LLdapDockerComposeConnectionDetails.getFromEnv(env, "LLDAP_LDAP_PORT", "3890");
            this.urls = new String[]{"%s://%s:%d".formatted(usesTls ? "ldaps" : "ldap", service.host(), service.ports().get(Integer.parseInt(ldapPort)))};
            this.base = LLdapDockerComposeConnectionDetails.getFromEnv(env, "LLDAP_LDAP_BASE_DN", "dc=example,dc=com");
            this.password = LLdapDockerComposeConnectionDetails.getFromEnv(env, "LLDAP_LDAP_USER_PASS", "password");
            this.username = "cn=admin,ou=people,%s".formatted(this.base);
        }

        private static String getFromEnv(Map<String, @Nullable String> env, String key, String defaultValue) {
            String result = env.get(key);
            return result != null ? result : defaultValue;
        }

        @Override
        public String[] getUrls() {
            return this.urls;
        }

        @Override
        public String getBase() {
            return this.base;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public String getPassword() {
            return this.password;
        }
    }
}

