/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.servlet;

import jakarta.servlet.http.Cookie;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.ee11.servlet.ErrorHandler;
import org.eclipse.jetty.ee11.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee11.servlet.ListenerHolder;
import org.eclipse.jetty.ee11.servlet.ServletHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.ee11.servlet.ServletMapping;
import org.eclipse.jetty.ee11.servlet.SessionHandler;
import org.eclipse.jetty.ee11.servlet.Source;
import org.eclipse.jetty.ee11.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee11.webapp.Configuration;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.ee11.webapp.WebInfConfiguration;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.SetCookieParser;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.NetworkConnectionLimit;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.session.DefaultSessionCache;
import org.eclipse.jetty.session.FileSessionDataStore;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionDataStore;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResourceFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.jetty.ForwardHeadersCustomizer;
import org.springframework.boot.jetty.JettyServerCustomizer;
import org.springframework.boot.jetty.JettyWebServer;
import org.springframework.boot.jetty.JettyWebServerFactory;
import org.springframework.boot.jetty.servlet.JasperInitializer;
import org.springframework.boot.jetty.servlet.JettyEmbeddedErrorHandler;
import org.springframework.boot.jetty.servlet.JettyEmbeddedWebAppContext;
import org.springframework.boot.jetty.servlet.JettyServletWebServer;
import org.springframework.boot.jetty.servlet.LoaderHidingResource;
import org.springframework.boot.jetty.servlet.ServletContextInitializerConfiguration;
import org.springframework.boot.web.error.ErrorPage;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.servlet.ConfigurableServletWebServerFactory;
import org.springframework.boot.web.server.servlet.ContextPath;
import org.springframework.boot.web.server.servlet.CookieSameSiteSupplier;
import org.springframework.boot.web.server.servlet.DocumentRoot;
import org.springframework.boot.web.server.servlet.ServletContextInitializers;
import org.springframework.boot.web.server.servlet.ServletWebServerSettings;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JettyServletWebServerFactory
extends JettyWebServerFactory
implements ConfigurableJettyWebServerFactory,
ConfigurableServletWebServerFactory,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(JettyServletWebServerFactory.class);
    private final ServletWebServerSettings settings = new ServletWebServerSettings();
    private ResourceLoader resourceLoader;

    public JettyServletWebServerFactory() {
    }

    public JettyServletWebServerFactory(int port) {
        super(port);
    }

    public JettyServletWebServerFactory(String contextPath, int port) {
        super(port);
        this.getSettings().setContextPath(ContextPath.of((String)contextPath));
    }

    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        JettyEmbeddedWebAppContext context = new JettyEmbeddedWebAppContext();
        context.getContext().getServletContext().setExtendedListenerTypes(true);
        int port = Math.max(this.getPort(), 0);
        InetSocketAddress address = new InetSocketAddress(this.getAddress(), port);
        Server server = this.createServer(address);
        context.setServer(server);
        this.configureWebAppContext(context, initializers);
        server.setHandler(this.addHandlerWrappers((Handler)context));
        logger.info((Object)("Server initialized with port: " + port));
        if (this.getMaxConnections() > -1) {
            server.addBean((Object)new NetworkConnectionLimit(this.getMaxConnections(), server.getConnectors()));
        }
        if (Ssl.isEnabled((Ssl)this.getSsl())) {
            this.customizeSsl(server, address);
        }
        for (JettyServerCustomizer customizer : this.getServerCustomizers()) {
            customizer.customize(server);
        }
        if (this.isUseForwardHeaders()) {
            new ForwardHeadersCustomizer().customize(server);
        }
        if (this.getShutdown() == Shutdown.GRACEFUL) {
            StatisticsHandler statisticsHandler = new StatisticsHandler();
            statisticsHandler.setHandler(server.getHandler());
            server.setHandler((Handler)statisticsHandler);
        }
        return this.getJettyWebServer(server);
    }

    private Server createServer(InetSocketAddress address) {
        Server server = new Server(this.getThreadPool());
        server.setConnectors(new Connector[]{this.createConnector(address, server)});
        server.setStopTimeout(0L);
        MimeTypes.Mutable mimeTypes = server.getMimeTypes();
        for (MimeMappings.Mapping mapping : this.getSettings().getMimeMappings()) {
            mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
        return server;
    }

    @Override
    protected Handler addHandlerWrappers(Handler handler) {
        handler = super.addHandlerWrappers(handler);
        if (!CollectionUtils.isEmpty((Collection)this.getSettings().getCookieSameSiteSuppliers())) {
            handler = this.applyWrapper(handler, new SuppliedSameSiteCookieHandlerWrapper(this.getSessionCookieName(), this.getSettings().getCookieSameSiteSuppliers()));
        }
        return handler;
    }

    private String getSessionCookieName() {
        String name = this.getSettings().getSession().getCookie().getName();
        return name != null ? name : "JSESSIONID";
    }

    protected final void configureWebAppContext(WebAppContext context, ServletContextInitializer ... initializers) {
        String contextPath;
        Assert.notNull((Object)context, (String)"'context' must not be null");
        context.clearAliasChecks();
        if (this.resourceLoader != null) {
            context.setClassLoader(this.resourceLoader.getClassLoader());
        }
        context.setContextPath(StringUtils.hasLength((String)(contextPath = this.getSettings().getContextPath().toString())) ? contextPath : "/");
        context.setDisplayName(this.getSettings().getDisplayName());
        this.configureDocumentRoot(context);
        if (this.getSettings().isRegisterDefaultServlet()) {
            this.addDefaultServlet(context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet(context);
            context.addBean((Object)new JasperInitializer(context), true);
        }
        this.addLocaleMappings(context);
        ServletContextInitializers initializersToUse = ServletContextInitializers.from((ServletWebServerSettings)this.settings, (ServletContextInitializer[])initializers);
        Configuration[] configurations = this.getWebAppContextConfigurations(context, initializersToUse);
        context.setConfigurations(configurations);
        context.setThrowUnavailableOnStartupException(true);
        this.configureSession(context);
        context.setTempDirectory(this.getTempDirectory(context));
        this.postProcessWebAppContext(context);
    }

    private boolean shouldRegisterJspServlet() {
        return this.settings.getJsp() != null && this.settings.getJsp().getRegistered() && ClassUtils.isPresent((String)this.settings.getJsp().getClassName(), (ClassLoader)this.getClass().getClassLoader());
    }

    private void configureSession(WebAppContext context) {
        Duration sessionTimeout;
        SessionHandler handler = context.getSessionHandler();
        Cookie.SameSite sessionSameSite = this.getSettings().getSession().getCookie().getSameSite();
        if (sessionSameSite != null && sessionSameSite != Cookie.SameSite.OMITTED) {
            handler.setSameSite(HttpCookie.SameSite.valueOf((String)sessionSameSite.name()));
        }
        handler.setMaxInactiveInterval(this.isNegative(sessionTimeout = this.getSettings().getSession().getTimeout()) ? -1 : (int)sessionTimeout.getSeconds());
        if (this.getSettings().getSession().isPersistent()) {
            DefaultSessionCache cache = new DefaultSessionCache((SessionManager)handler);
            FileSessionDataStore store = new FileSessionDataStore();
            store.setStoreDir(this.getSettings().getSession().getSessionStoreDirectory().getValidDirectory(true));
            cache.setSessionDataStore((SessionDataStore)store);
            handler.setSessionCache((SessionCache)cache);
        }
    }

    @Contract(value="null -> true")
    private boolean isNegative(@Nullable Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative();
    }

    private void addLocaleMappings(WebAppContext context) {
        this.getSettings().getLocaleCharsetMappings().forEach((locale, charset) -> context.addLocaleEncoding(locale.toString(), charset.toString()));
    }

    private @Nullable File getTempDirectory(WebAppContext context) {
        String temp = System.getProperty("java.io.tmpdir");
        return temp != null ? new File(temp, this.getTempDirectoryPrefix(context) + String.valueOf(UUID.randomUUID())) : null;
    }

    private String getTempDirectoryPrefix(WebAppContext context) {
        try {
            return ((JettyEmbeddedWebAppContext)context).getCanonicalNameForTmpDir();
        }
        catch (Throwable ex) {
            return WebInfConfiguration.getCanonicalNameForWebAppTmpDir((WebAppContext)context);
        }
    }

    private void configureDocumentRoot(WebAppContext handler) {
        DocumentRoot documentRoot = new DocumentRoot(logger);
        documentRoot.setDirectory(this.settings.getDocumentRoot());
        File root = documentRoot.getValidDirectory();
        File docBase = root != null ? root : this.createTempDir("jetty-docbase");
        try {
            ResourceFactory resourceFactory = handler.getResourceFactory();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            Resource rootResource = docBase.isDirectory() ? resourceFactory.newResource(docBase.getCanonicalFile().toURI()) : resourceFactory.newJarFileResource(docBase.toURI());
            resources.add(root != null ? new LoaderHidingResource(rootResource, rootResource) : rootResource);
            URLResourceFactory urlResourceFactory = new URLResourceFactory();
            for (URL resourceJarUrl : this.getSettings().getStaticResourceUrls()) {
                Resource resource = this.createResource(resourceJarUrl, resourceFactory, urlResourceFactory);
                if (resource == null) continue;
                resources.add(resource);
            }
            handler.setBaseResource(ResourceFactory.combine(resources));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private @Nullable Resource createResource(URL url, ResourceFactory resourceFactory, URLResourceFactory urlResourceFactory) throws Exception {
        if ("file".equals(url.getProtocol())) {
            File file = new File(url.toURI());
            if (file.isFile()) {
                return resourceFactory.newResource("jar:" + String.valueOf(url) + "!/META-INF/resources/");
            }
            if (file.isDirectory()) {
                return resourceFactory.newResource(url).resolve("META-INF/resources/");
            }
        }
        return urlResourceFactory.newResource(String.valueOf(url) + "META-INF/resources/");
    }

    protected final void addDefaultServlet(WebAppContext context) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("default");
        holder.setClassName("org.eclipse.jetty.ee11.servlet.DefaultServlet");
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitOrder(1);
        context.getServletHandler().addServletWithMapping(holder, "/");
        ServletMapping servletMapping = context.getServletHandler().getServletMapping("/");
        servletMapping.setFromDefaultDescriptor(true);
    }

    protected final void addJspServlet(WebAppContext context) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("jsp");
        holder.setClassName(this.settings.getJsp().getClassName());
        holder.setInitParameter("fork", "false");
        holder.setInitParameters(this.settings.getJsp().getInitParameters());
        holder.setInitOrder(3);
        context.getServletHandler().addServlet(holder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("jsp");
        mapping.setPathSpecs(new String[]{"*.jsp", "*.jspx"});
        context.getServletHandler().addServletMapping(mapping);
    }

    protected Configuration[] getWebAppContextConfigurations(WebAppContext webAppContext, ServletContextInitializers initializers) {
        ArrayList<Object> configurations = new ArrayList<Object>();
        configurations.add(this.getServletContextInitializerConfiguration(webAppContext, initializers));
        configurations.add(this.getErrorPageConfiguration());
        configurations.add(this.getMimeTypeConfiguration());
        configurations.add((Object)new WebListenersConfiguration(this.getSettings().getWebListenerClassNames()));
        configurations.addAll(this.getConfigurations());
        return configurations.toArray(new Configuration[0]);
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(new AbstractConfiguration.Builder()){

            public void configure(WebAppContext context) throws Exception {
                JettyEmbeddedErrorHandler errorHandler = new JettyEmbeddedErrorHandler();
                context.setErrorHandler((Request.Handler)errorHandler);
                JettyServletWebServerFactory.this.addJettyErrorPages((ErrorHandler)errorHandler, JettyServletWebServerFactory.this.getErrorPages());
            }
        };
    }

    private Configuration getMimeTypeConfiguration() {
        return new AbstractConfiguration(new AbstractConfiguration.Builder()){

            public void configure(WebAppContext context) throws Exception {
                MimeTypes.Mutable mimeTypes = context.getMimeTypes();
                mimeTypes.clear();
                for (MimeMappings.Mapping mapping : JettyServletWebServerFactory.this.getSettings().getMimeMappings()) {
                    mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
            }
        };
    }

    protected Configuration getServletContextInitializerConfiguration(WebAppContext webAppContext, ServletContextInitializers initializers) {
        return new ServletContextInitializerConfiguration(initializers);
    }

    protected void postProcessWebAppContext(WebAppContext webAppContext) {
    }

    protected JettyWebServer getJettyWebServer(Server server) {
        return new JettyServletWebServer(server, this.getPort() >= 0);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private void addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        if (errorHandler instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler handler = (ErrorPageErrorHandler)errorHandler;
            for (ErrorPage errorPage : errorPages) {
                if (errorPage.isGlobal()) {
                    handler.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
                    continue;
                }
                if (errorPage.getExceptionName() != null) {
                    handler.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
                    continue;
                }
                handler.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
            }
        }
    }

    public ServletWebServerSettings getSettings() {
        return this.settings;
    }

    private static class SuppliedSameSiteCookieHandlerWrapper
    extends Handler.Wrapper {
        private static final SetCookieParser setCookieParser = SetCookieParser.newInstance();
        private final String sessionCookieName;
        private final List<? extends CookieSameSiteSupplier> suppliers;

        SuppliedSameSiteCookieHandlerWrapper(String sessionCookieName, List<? extends CookieSameSiteSupplier> suppliers) {
            this.sessionCookieName = sessionCookieName;
            this.suppliers = suppliers;
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            SuppliedSameSiteCookieResponse wrappedResponse = new SuppliedSameSiteCookieResponse(request, response);
            return super.handle(request, (Response)wrappedResponse, callback);
        }

        private class SuppliedSameSiteCookieResponse
        extends Response.Wrapper {
            private final HttpFields.Mutable wrappedHeaders;

            SuppliedSameSiteCookieResponse(Request request, Response wrapped) {
                super(request, wrapped);
                this.wrappedHeaders = new SuppliedSameSiteCookieHeaders(request.getConnectionMetaData().getHttpConfiguration().getResponseCookieCompliance(), wrapped.getHeaders());
            }

            public HttpFields.Mutable getHeaders() {
                return this.wrappedHeaders;
            }
        }

        private class SuppliedSameSiteCookieHeaders
        extends HttpFields.Mutable.Wrapper {
            private final CookieCompliance compliance;

            SuppliedSameSiteCookieHeaders(CookieCompliance compliance, HttpFields.Mutable fields) {
                super(fields);
                this.compliance = compliance;
            }

            public HttpField onAddField(HttpField field) {
                return field.getHeader() != HttpHeader.SET_COOKIE ? field : this.onAddSetCookieField(field);
            }

            private HttpField onAddSetCookieField(HttpField field) {
                HttpCookie cookie = setCookieParser.parse(field.getValue());
                if (cookie == null || this.isSessionCookie(cookie)) {
                    return field;
                }
                Cookie.SameSite sameSite = this.getSameSite(cookie);
                if (sameSite == null) {
                    return field;
                }
                HttpCookie updatedCookie = this.buildCookieWithUpdatedSameSite(cookie, sameSite);
                return new HttpCookieUtils.SetCookieHttpField(updatedCookie, this.compliance);
            }

            private boolean isSessionCookie(HttpCookie cookie) {
                return SuppliedSameSiteCookieHandlerWrapper.this.sessionCookieName.equals(cookie.getName());
            }

            private HttpCookie buildCookieWithUpdatedSameSite(HttpCookie cookie, Cookie.SameSite sameSite) {
                return HttpCookie.build((HttpCookie)cookie).sameSite(HttpCookie.SameSite.from((String)sameSite.name())).build();
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Cookie.SameSite getSameSite(HttpCookie cookie) {
                return this.getSameSite(this.asServletCookie(cookie));
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Cookie.SameSite getSameSite(Cookie cookie) {
                return SuppliedSameSiteCookieHandlerWrapper.this.suppliers.stream().map(supplier -> supplier.getSameSite(cookie)).filter(Objects::nonNull).findFirst().orElse(null);
            }

            private Cookie asServletCookie(HttpCookie cookie) {
                Cookie servletCookie = new Cookie(cookie.getName(), cookie.getValue());
                cookie.getAttributes().forEach((arg_0, arg_1) -> ((Cookie)servletCookie).setAttribute(arg_0, arg_1));
                return servletCookie;
            }
        }
    }

    private static class WebListenersConfiguration
    extends AbstractConfiguration {
        private final Set<String> classNames;

        WebListenersConfiguration(Set<String> webListenerClassNames) {
            super(new AbstractConfiguration.Builder());
            this.classNames = webListenerClassNames;
        }

        public void configure(WebAppContext context) throws Exception {
            ServletHandler servletHandler = context.getServletHandler();
            for (String className : this.classNames) {
                this.configure(context, servletHandler, className);
            }
        }

        private void configure(WebAppContext context, ServletHandler servletHandler, String className) throws ClassNotFoundException {
            ListenerHolder holder = servletHandler.newListenerHolder(new Source(Source.Origin.ANNOTATION, className));
            holder.setHeldClass(this.loadClass(context, className));
            servletHandler.addListener(holder);
        }

        private Class<? extends EventListener> loadClass(WebAppContext context, String className) throws ClassNotFoundException {
            ClassLoader classLoader = context.getClassLoader();
            classLoader = classLoader != null ? classLoader : ((Object)((Object)this)).getClass().getClassLoader();
            return classLoader.loadClass(className);
        }
    }
}

