/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure.servlet;

import jakarta.servlet.ServletContext;
import org.eclipse.jetty.ee11.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee11.webapp.Configuration;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.ee11.websocket.jakarta.server.JakartaWebSocketServerContainer;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.ee11.websocket.servlet.WebSocketUpgradeFilter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.springframework.boot.jetty.servlet.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;

public class WebSocketJettyServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory>,
Ordered {
    public void customize(JettyServletWebServerFactory factory) {
        factory.addConfigurations(new Configuration[]{new AbstractConfiguration(new AbstractConfiguration.Builder()){

            public void configure(WebAppContext context) throws Exception {
                if (JettyWebSocketServerContainer.getContainer((ServletContext)context.getServletContext()) == null) {
                    WebSocketServerComponents.ensureWebSocketComponents((Server)context.getServer(), (ContextHandler)context.getContext().getContextHandler());
                    JettyWebSocketServerContainer.ensureContainer((ServletContext)context.getServletContext());
                }
                if (JakartaWebSocketServerContainer.getContainer((ServletContext)context.getServletContext()) == null) {
                    WebSocketServerComponents.ensureWebSocketComponents((Server)context.getServer(), (ContextHandler)context.getContext().getContextHandler());
                    WebSocketUpgradeFilter.ensureFilter((ServletContext)context.getServletContext());
                    WebSocketMappings.ensureMappings((ContextHandler)context.getContext().getContextHandler());
                    JakartaWebSocketServerContainer.ensureContainer((ServletContext)context.getServletContext());
                }
            }
        }});
    }

    public int getOrder() {
        return 0;
    }
}

