/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.ThrowingFunction;

public enum EmbeddedDatabaseConnection {
    NONE(null),
    H2("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE"),
    DERBY("jdbc:derby:memory:%s;create=true"),
    HSQLDB("org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:%s");

    private final @Nullable String alternativeDriverClass;
    private final @Nullable String url;

    private EmbeddedDatabaseConnection(String url) {
        this(null, url);
    }

    private EmbeddedDatabaseConnection(String fallbackDriverClass, String url) {
        this.alternativeDriverClass = fallbackDriverClass;
        this.url = url;
    }

    public @Nullable String getDriverClassName() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> null;
            case 1 -> DatabaseDriver.H2.getDriverClassName();
            case 2 -> DatabaseDriver.DERBY.getDriverClassName();
            case 3 -> DatabaseDriver.HSQLDB.getDriverClassName();
        };
    }

    public @Nullable EmbeddedDatabaseType getType() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> null;
            case 1 -> EmbeddedDatabaseType.H2;
            case 2 -> EmbeddedDatabaseType.DERBY;
            case 3 -> EmbeddedDatabaseType.HSQL;
        };
    }

    public @Nullable String getUrl(String databaseName) {
        Assert.hasText((String)databaseName, (String)"'databaseName' must not be empty");
        return this.url != null ? String.format(this.url, databaseName) : null;
    }

    boolean isEmbeddedUrl(String url) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> false;
            case 1 -> url.contains(":h2:mem");
            case 2 -> true;
            case 3 -> url.contains(":hsqldb:mem:");
        };
    }

    boolean isDriverCompatible(@Nullable String driverClass) {
        return driverClass != null && (driverClass.equals(this.getDriverClassName()) || driverClass.equals(this.alternativeDriverClass));
    }

    public static boolean isEmbedded(@Nullable String driverClass, @Nullable String url) {
        if (driverClass == null) {
            return false;
        }
        EmbeddedDatabaseConnection connection = EmbeddedDatabaseConnection.getEmbeddedDatabaseConnection(driverClass);
        if (connection == NONE) {
            return false;
        }
        return url == null || connection.isEmbeddedUrl(url);
    }

    private static EmbeddedDatabaseConnection getEmbeddedDatabaseConnection(String driverClass) {
        return Stream.of(H2, HSQLDB, DERBY).filter(connection -> connection.isDriverCompatible(driverClass)).findFirst().orElse(NONE);
    }

    public static boolean isEmbedded(DataSource dataSource) {
        boolean bl;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                bl = (Boolean)new IsEmbedded().apply(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public static EmbeddedDatabaseConnection get(@Nullable ClassLoader classLoader) {
        for (EmbeddedDatabaseConnection candidate : EmbeddedDatabaseConnection.values()) {
            if (candidate == NONE) continue;
            String driverClassName = candidate.getDriverClassName();
            Assert.state((driverClassName != null ? 1 : 0) != 0, (String)"'driverClassName' must not be null");
            if (!ClassUtils.isPresent((String)driverClassName, (ClassLoader)classLoader)) continue;
            return candidate;
        }
        return NONE;
    }

    private static final class IsEmbedded
    implements ThrowingFunction<Connection, Boolean> {
        private IsEmbedded() {
        }

        public Boolean applyWithException(Connection connection) throws SQLException, DataAccessException {
            EmbeddedDatabaseConnection[] candidates;
            DatabaseMetaData metaData = connection.getMetaData();
            String productName = metaData.getDatabaseProductName();
            if (productName == null) {
                return false;
            }
            productName = productName.toUpperCase(Locale.ENGLISH);
            for (EmbeddedDatabaseConnection candidate : candidates = EmbeddedDatabaseConnection.values()) {
                if (candidate == NONE) continue;
                EmbeddedDatabaseType type = candidate.getType();
                Assert.state((type != null ? 1 : 0) != 0, (String)"'type' must not be null");
                if (!productName.contains(type.name())) continue;
                String url = metaData.getURL();
                return url == null || candidate.isEmbeddedUrl(url);
            }
            return false;
        }
    }
}

