/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.docker.compose;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.docker.compose.JdbcUrlBuilder;
import org.springframework.boot.jdbc.docker.compose.SqlServerEnvironment;

class SqlServerJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    protected SqlServerJdbcDockerComposeConnectionDetailsFactory() {
        super("mssql/server", new String[0]);
    }

    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new SqlServerJdbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class SqlServerJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final JdbcUrlBuilder jdbcUrlBuilder = new SqlServerJdbcUrlBuilder("sqlserver", 1433);
        private final SqlServerEnvironment environment;
        private final String jdbcUrl;

        SqlServerJdbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new SqlServerEnvironment(service.env());
            this.jdbcUrl = this.disableEncryptionIfNecessary(jdbcUrlBuilder.build(service));
        }

        private String disableEncryptionIfNecessary(String jdbcUrl) {
            if (jdbcUrl.contains(";encrypt=false;")) {
                return jdbcUrl;
            }
            StringBuilder jdbcUrlBuilder = new StringBuilder(jdbcUrl);
            if (!jdbcUrl.endsWith(";")) {
                jdbcUrlBuilder.append(";");
            }
            jdbcUrlBuilder.append("encrypt=false;");
            return jdbcUrlBuilder.toString();
        }

        @Override
        public String getUsername() {
            return this.environment.getUsername();
        }

        @Override
        public String getPassword() {
            return this.environment.getPassword();
        }

        @Override
        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        private static final class SqlServerJdbcUrlBuilder
        extends JdbcUrlBuilder {
            private SqlServerJdbcUrlBuilder(String driverProtocol, int containerPort) {
                super(driverProtocol, containerPort);
            }

            @Override
            protected void appendParameters(StringBuilder url, String parameters) {
                url.append(";").append(parameters);
            }
        }
    }
}

