/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.jdbc.autoconfigure.DataSourceCheckpointRestoreConfiguration;
import org.springframework.boot.jdbc.autoconfigure.DataSourceConfiguration;
import org.springframework.boot.jdbc.autoconfigure.DataSourceInitializationAutoConfiguration;
import org.springframework.boot.jdbc.autoconfigure.DataSourceJmxConfiguration;
import org.springframework.boot.jdbc.autoconfigure.DataSourcePoolMetadataProvidersConfiguration;
import org.springframework.boot.jdbc.autoconfigure.DataSourceProperties;
import org.springframework.boot.jdbc.autoconfigure.EmbeddedDataSourceConfiguration;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.autoconfigure.PropertiesJdbcConnectionDetails;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={DataSourceInitializationAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@ConditionalOnMissingBean(type={"io.r2dbc.spi.ConnectionFactory"})
@EnableConfigurationProperties(value={DataSourceProperties.class})
@Import(value={DataSourcePoolMetadataProvidersConfiguration.class, DataSourceCheckpointRestoreConfiguration.class})
public class DataSourceAutoConfiguration {

    static class EmbeddedDatabaseCondition
    extends SpringBootCondition {
        private static final String DATASOURCE_URL_PROPERTY = "spring.datasource.url";
        private static final String EMBEDDED_DATABASE_TYPE = "org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType";
        private final SpringBootCondition pooledCondition = new PooledDataSourceCondition();

        EmbeddedDatabaseCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"EmbeddedDataSource", (Object[])new Object[0]);
            if (this.hasDataSourceUrlProperty(context)) {
                return ConditionOutcome.noMatch((ConditionMessage)message.because("spring.datasource.url is set"));
            }
            if (this.anyMatches(context, metadata, new Condition[]{this.pooledCondition})) {
                return ConditionOutcome.noMatch((ConditionMessage)message.foundExactly((Object)"supported pooled data source"));
            }
            if (!ClassUtils.isPresent((String)EMBEDDED_DATABASE_TYPE, (ClassLoader)context.getClassLoader())) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("required class").items(ConditionMessage.Style.QUOTE, new Object[]{EMBEDDED_DATABASE_TYPE}));
            }
            EmbeddedDatabaseType type = EmbeddedDatabaseConnection.get(context.getClassLoader()).getType();
            if (type == null) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("embedded database").atAll());
            }
            return ConditionOutcome.match((ConditionMessage)message.found("embedded database").items(new Object[]{type}));
        }

        private boolean hasDataSourceUrlProperty(ConditionContext context) {
            Environment environment = context.getEnvironment();
            if (environment.containsProperty(DATASOURCE_URL_PROPERTY)) {
                try {
                    return StringUtils.hasText((String)environment.getProperty(DATASOURCE_URL_PROPERTY));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    static class PooledDataSourceAvailableCondition
    extends SpringBootCondition {
        PooledDataSourceAvailableCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"PooledDataSource", (Object[])new Object[0]);
            if (DataSourceBuilder.findType(context.getClassLoader()) != null) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"supported DataSource"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("supported DataSource").atAll());
        }
    }

    static class PooledDataSourceCondition
    extends AnyNestedCondition {
        PooledDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={PooledDataSourceAvailableCondition.class})
        static class PooledDataSourceAvailable {
            PooledDataSourceAvailable() {
            }
        }

        @ConditionalOnProperty(value={"spring.datasource.type"})
        static class ExplicitType {
            ExplicitType() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={PooledDataSourceCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class, XADataSource.class})
    @Import(value={DataSourceConfiguration.Hikari.class, DataSourceConfiguration.Tomcat.class, DataSourceConfiguration.Dbcp2.class, DataSourceConfiguration.OracleUcp.class, DataSourceConfiguration.Generic.class, DataSourceJmxConfiguration.class})
    protected static class PooledDataSourceConfiguration {
        protected PooledDataSourceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JdbcConnectionDetails.class})
        PropertiesJdbcConnectionDetails jdbcConnectionDetails(DataSourceProperties properties) {
            return new PropertiesJdbcConnectionDetails(properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={EmbeddedDatabaseCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class, XADataSource.class})
    @Import(value={EmbeddedDataSourceConfiguration.class})
    protected static class EmbeddedDatabaseConfiguration {
        protected EmbeddedDatabaseConfiguration() {
        }
    }
}

