/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import java.net.URI;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.autoconfigure.ApiversionProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.client.ApiVersionInserter;

public final class PropertiesApiVersionInserter
implements ApiVersionInserter {
    static final PropertiesApiVersionInserter EMPTY = new PropertiesApiVersionInserter(new ApiVersionInserter(){});
    private final ApiVersionInserter delegate;

    private PropertiesApiVersionInserter(ApiVersionInserter delegate) {
        this.delegate = delegate;
    }

    public URI insertVersion(Object version, URI uri) {
        return this.delegate.insertVersion(version, uri);
    }

    public void insertVersion(Object version, HttpHeaders headers) {
        this.delegate.insertVersion(version, headers);
    }

    public static PropertiesApiVersionInserter get(ApiversionProperties.Insert properties) {
        ApiVersionInserter.Builder builder = PropertiesApiVersionInserter.builder(properties);
        return builder != null ? new PropertiesApiVersionInserter(builder.build()) : EMPTY;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ApiVersionInserter.Builder builder(ApiversionProperties.Insert properties) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        PropertyMapper map = PropertyMapper.get();
        ApiVersionInserter.Builder builder = ApiVersionInserter.builder();
        Counter counter = new Counter();
        map.from(properties::getHeader).whenHasText().as(counter::counted).to(arg_0 -> ((ApiVersionInserter.Builder)builder).useHeader(arg_0));
        map.from(properties::getQueryParameter).whenHasText().as(counter::counted).to(arg_0 -> ((ApiVersionInserter.Builder)builder).useQueryParam(arg_0));
        map.from(properties::getPathSegment).as(counter::counted).to(arg_0 -> ((ApiVersionInserter.Builder)builder).usePathSegment(arg_0));
        map.from(properties::getMediaTypeParameter).as(counter::counted).to(arg_0 -> ((ApiVersionInserter.Builder)builder).useMediaTypeParam(arg_0));
        return !counter.isEmpty() ? builder : null;
    }

    private static final class Counter {
        private boolean empty = true;

        private Counter() {
        }

        <T> T counted(T value) {
            this.empty = false;
            return value;
        }

        boolean isEmpty() {
            return this.empty;
        }
    }
}

